/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.MethodBuilder;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.GetDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class BindDefinition
implements Function<ClassRef, TypeDef> {
    public static BindDefinition FUNCTION = new BindDefinition();

    public static TypeDef of(ClassRef classRef) {
        return FUNCTION.apply(classRef);
    }

    @Override
    public TypeDef apply(ClassRef t) {
        List arguments = t.getArguments();
        TypeDef definition = GetDefinition.of(t);
        if (arguments.isEmpty()) {
            return definition;
        }
        List parameters = definition.getParameters();
        List newParameters = definition.getParameters();
        HashMap<String, TypeRef> mappings = new HashMap<String, TypeRef>();
        for (int i = 0; i < arguments.size(); ++i) {
            String name = ((TypeParamDef)parameters.get(i)).getName();
            TypeRef typeRef = (TypeRef)arguments.get(i);
            mappings.put(name, typeRef);
            newParameters.remove(i);
        }
        return ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(definition).withParameters(newParameters)).accept(new Visitor[]{BindDefinition.mapClassRefArguments(mappings), BindDefinition.mapGenericProperties(mappings), BindDefinition.mapGenericReturnTypes(mappings)})).build();
    }

    private static TypedVisitor<PropertyBuilder> mapGenericProperties(final Map<String, TypeRef> mappings) {
        return new TypedVisitor<PropertyBuilder>(){

            public void visit(PropertyBuilder property) {
                TypeParamRef typeParamRef;
                String key;
                TypeRef paramRef;
                TypeRef typeRef = property.buildTypeRef();
                if (typeRef instanceof TypeParamRef && (paramRef = (TypeRef)mappings.get(key = (typeParamRef = (TypeParamRef)typeRef).getName())) != null) {
                    property.withTypeRef(paramRef);
                }
            }
        };
    }

    private static TypedVisitor<MethodBuilder> mapGenericReturnTypes(final Map<String, TypeRef> mappings) {
        return new TypedVisitor<MethodBuilder>(){

            public void visit(MethodBuilder method) {
                TypeParamRef typeParamRef;
                String key;
                TypeRef paramRef;
                TypeRef typeRef = method.buildReturnType();
                if (typeRef instanceof TypeParamRef && (paramRef = (TypeRef)mappings.get(key = (typeParamRef = (TypeParamRef)typeRef).getName())) != null) {
                    method.withReturnType(paramRef);
                }
            }
        };
    }

    private static TypedVisitor<ClassRefBuilder> mapClassRefArguments(final Map<String, TypeRef> mappings) {
        return new TypedVisitor<ClassRefBuilder>(){

            public void visit(ClassRefBuilder c) {
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                Iterator iterator = c.buildArguments().iterator();
                while (iterator.hasNext()) {
                    TypeParamRef typeParamRef;
                    TypeRef mapping;
                    TypeRef arg;
                    TypeRef mappedRef = arg = (TypeRef)iterator.next();
                    if (arg instanceof TypeParamRef && (mapping = (TypeRef)mappings.get((typeParamRef = (TypeParamRef)arg).getName())) != null) {
                        mappedRef = mapping;
                    }
                    arguments.add(mappedRef);
                }
                c.withArguments(arguments);
            }
        };
    }
}

