/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2.integration;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.GenericOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SwaggerLoader {
    private String outputFormat;
    private String resourcePackages;
    private String resourceClasses;
    private String filterClass;
    private String readerClass;
    private String contextId;
    private String scannerClass;
    private Boolean prettyPrint = false;
    private Boolean readAllResources = Boolean.TRUE;
    private String ignoredRoutes;
    private String openapiAsString;
    private String objectMapperProcessorClass;
    private String modelConverterClasses;
    private Boolean sortOutput = false;

    public String getObjectMapperProcessorClass() {
        return this.objectMapperProcessorClass;
    }

    public void setObjectMapperProcessorClass(String objectMapperProcessorClass) {
        this.objectMapperProcessorClass = objectMapperProcessorClass;
    }

    public String getModelConverterClasses() {
        return this.modelConverterClasses;
    }

    public void setModelConverterClasses(String modelConverterClasses) {
        this.modelConverterClasses = modelConverterClasses;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getResourcePackages() {
        return this.resourcePackages;
    }

    public void setResourcePackages(String resourcePackages) {
        this.resourcePackages = resourcePackages;
    }

    public String getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(String resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getReaderClass() {
        return this.readerClass;
    }

    public void setReaderClass(String readerClass) {
        this.readerClass = readerClass;
    }

    public String getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(String scannerClass) {
        this.scannerClass = scannerClass;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Boolean getReadAllResources() {
        return this.readAllResources;
    }

    public void setReadAllResources(Boolean readAllResources) {
        this.readAllResources = readAllResources;
    }

    public String getIgnoredRoutes() {
        return this.ignoredRoutes;
    }

    public void setIgnoredRoutes(String ignoredRoutes) {
        this.ignoredRoutes = ignoredRoutes;
    }

    public String getOpenapiAsString() {
        return this.openapiAsString;
    }

    public void setOpenapiAsString(String openapiAsString) {
        this.openapiAsString = openapiAsString;
    }

    public Boolean getSortOutput() {
        return this.sortOutput;
    }

    public void setSortOutput(Boolean sortOutput) {
        this.sortOutput = sortOutput;
    }

    public Map<String, String> resolve() throws Exception {
        HashSet<String> ignoredRoutesSet = null;
        if (StringUtils.isNotBlank((CharSequence)this.ignoredRoutes)) {
            ignoredRoutesSet = new HashSet<String>(Arrays.asList(this.ignoredRoutes.split(",")));
        }
        HashSet<String> resourceClassesSet = null;
        if (StringUtils.isNotBlank((CharSequence)this.resourceClasses)) {
            resourceClassesSet = new HashSet<String>(Arrays.asList(this.resourceClasses.split(",")));
        }
        HashSet<String> resourcePackagesSet = null;
        if (StringUtils.isNotBlank((CharSequence)this.resourcePackages)) {
            resourcePackagesSet = new HashSet<String>(Arrays.asList(this.resourcePackages.split(",")));
        }
        LinkedHashSet<String> modelConverterSet = null;
        if (StringUtils.isNotBlank((CharSequence)this.modelConverterClasses)) {
            modelConverterSet = new LinkedHashSet<String>(Arrays.asList(this.modelConverterClasses.split(",")));
        }
        OpenAPI openAPIInput = null;
        if (StringUtils.isNotBlank((CharSequence)this.openapiAsString)) {
            try {
                openAPIInput = (OpenAPI)Json.mapper().readValue(this.openapiAsString, OpenAPI.class);
            }
            catch (Exception e) {
                try {
                    openAPIInput = (OpenAPI)Yaml.mapper().readValue(this.openapiAsString, OpenAPI.class);
                }
                catch (Exception e1) {
                    throw new Exception("Error reading/deserializing openapi input: " + e.getMessage(), e);
                }
            }
        }
        SwaggerConfiguration config = new SwaggerConfiguration().filterClass(this.filterClass).ignoredRoutes(ignoredRoutesSet).prettyPrint(this.prettyPrint).readAllResources(this.readAllResources).openAPI(openAPIInput).readerClass(this.readerClass).scannerClass(this.scannerClass).resourceClasses(resourceClassesSet).resourcePackages(resourcePackagesSet).objectMapperProcessorClass(this.objectMapperProcessorClass).modelConverterClasses(modelConverterSet).sortOutput(this.sortOutput);
        try {
            GenericOpenApiContextBuilder builder = new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)config);
            if (StringUtils.isNotBlank((CharSequence)this.contextId)) {
                builder.ctxId(this.contextId);
            }
            OpenApiContext context = builder.buildContext(true);
            OpenAPI openAPI = context.read();
            if (StringUtils.isNotBlank((CharSequence)this.filterClass)) {
                try {
                    OpenAPISpecFilter filterImpl = (OpenAPISpecFilter)this.getClass().getClassLoader().loadClass(this.filterClass).newInstance();
                    SpecFilter f = new SpecFilter();
                    openAPI = f.filter(openAPI, filterImpl, new HashMap(), new HashMap(), new HashMap());
                }
                catch (Exception e) {
                    throw new Exception("Error applying filter to API specification: " + e.getMessage(), e);
                }
            }
            String openapiJson = null;
            String openapiYaml = null;
            if ("JSON".equals(this.outputFormat) || "JSONANDYAML".equals(this.outputFormat)) {
                openapiJson = this.prettyPrint != null && this.prettyPrint != false ? context.getOutputJsonMapper().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)openAPI) : context.getOutputJsonMapper().writeValueAsString((Object)openAPI);
            }
            if ("YAML".equals(this.outputFormat) || "JSONANDYAML".equals(this.outputFormat)) {
                openapiYaml = this.prettyPrint != null && this.prettyPrint != false ? context.getOutputYamlMapper().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)openAPI) : context.getOutputYamlMapper().writeValueAsString((Object)openAPI);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("JSON", openapiJson);
            map.put("YAML", openapiYaml);
            return map;
        }
        catch (OpenApiConfigurationException e) {
            throw new Exception("Error resolving API specification: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception("Error resolving API specification: " + e.getMessage(), e);
        }
    }
}

