/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.utils.EnumPropertyNamingUtils;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKotlinCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(AbstractKotlinCodegen.class);
    protected String artifactId;
    protected String artifactVersion = "1.0.0";
    protected String groupId = "io.swagger";
    protected String packageName;
    protected String sourceFolder = "src/main/kotlin";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.camelCase;

    public AbstractKotlinCodegen() {
        this.supportsInheritance = true;
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Map", "kotlin.collections.Set"));
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "annotation", "as", "break", "case", "catch", "class", "companion", "const", "constructor", "continue", "crossinline", "data", "delegate", "do", "else", "enum", "external", "false", "final", "finally", "for", "fun", "if", "in", "infix", "init", "inline", "inner", "interface", "internal", "is", "it", "lateinit", "lazy", "noinline", "null", "object", "open", "operator", "out", "override", "package", "private", "protected", "public", "reified", "return", "sealed", "super", "suspend", "tailrec", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "vararg", "when", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.LocalDateTime");
        this.typeMapping.put("date", "java.time.LocalDateTime");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.Array");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.Array<kotlin.Byte>");
        this.typeMapping.put("Date", "java.time.LocalDateTime");
        this.typeMapping.put("DateTime", "java.time.LocalDateTime");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.instantiationTypes.put("array", "arrayOf");
        this.instantiationTypes.put("list", "arrayOf");
        this.instantiationTypes.put("map", "mapOf");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.specialCharReplacements.put(";", "Semicolon");
        this.cliOptions.clear();
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageName", "Generated artifact package name (e.g. io.swagger).", this.packageName);
        this.addOption("groupId", "Generated artifact package's organization (i.e. maven groupId).", this.groupId);
        this.addOption("artifactId", "Generated artifact id (name of jar).", this.artifactId);
        this.addOption("artifactVersion", "Generated artifact's package version.", this.artifactVersion);
        CliOption enumPropertyNamingOpt = new CliOption("enumPropertyNaming", "Naming convention for enum properties: 'camelCase', 'PascalCase', 'snake_case', 'UPPERCASE', and 'original'");
        this.cliOptions.add(enumPropertyNamingOpt.defaultValue(this.enumPropertyNaming.name()));
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        return String.format("`%s`", name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    public void setEnumPropertyNaming(String enumPropertyNamingType) {
        this.enumPropertyNaming = EnumPropertyNamingUtils.parseEnumPropertyNaming(enumPropertyNamingType);
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            return this.getArrayTypeDeclaration((ArrayProperty)p);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<kotlin.String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(super.postProcessModels(objs));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.setModelPackage(this.packageName + ".models");
            }
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.setApiPackage(this.packageName + ".apis");
            }
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            LOGGER.warn("invokerPackage with " + this.getName() + " generator is ignored. Use " + "packageName" + ".");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String toVarName(String name) {
        return super.toVarName(this.sanitizeKotlinSpecificNames(name));
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name);
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String modified;
        if (value.length() == 0) {
            modified = "EMPTY";
        } else {
            modified = value;
            modified = this.sanitizeKotlinSpecificNames(modified);
        }
        modified = modified.toUpperCase();
        if (this.isReservedWord(modified)) {
            return this.escapeReservedWord(modified);
        }
        return modified;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (this.isPrimivite(datatype)) {
            return value;
        }
        if ("java.math.BigDecimal".equalsIgnoreCase(datatype)) {
            return "java.math.BigDecimal(\"" + value + "\")";
        }
        return super.toEnumValue(value, datatype);
    }

    @Override
    public boolean isPrimivite(String datatype) {
        return "kotlin.Byte".equalsIgnoreCase(datatype) || "kotlin.Short".equalsIgnoreCase(datatype) || "kotlin.Int".equalsIgnoreCase(datatype) || "kotlin.Long".equalsIgnoreCase(datatype) || "kotlin.Float".equalsIgnoreCase(datatype) || "kotlin.Double".equalsIgnoreCase(datatype) || "kotlin.Boolean".equalsIgnoreCase(datatype);
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof ArrayProperty) {
            return this.getArrayTypeDeclaration((ArrayProperty)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "");
        modifiedName = this.sanitizeKotlinSpecificNames(modifiedName);
        if ((modifiedName = AbstractKotlinCodegen.camelize(modifiedName)).equalsIgnoreCase("Companion")) {
            modifiedName = "_" + modifiedName;
        }
        if (modifiedName.matches("^\\d.*")) {
            String modelName = "Model" + modifiedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return modifiedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    private String getArrayTypeDeclaration(ArrayProperty arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Property items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    private String sanitizeKotlinSpecificNames(String name) {
        String word = this.removeNonNameElementToCamelCase(name);
        for (Map.Entry specialCharacters : this.specialCharReplacements.entrySet()) {
            if (((String)specialCharacters.getKey()).equals("_")) continue;
            word = word.replaceAll("\\Q" + (String)specialCharacters.getKey() + "\\E", (String)specialCharacters.getValue());
        }
        if ((word = word.replaceAll("\\W+", "_")).matches("\\d.*")) {
            word = "_" + word;
        }
        if (word.matches("^_*$")) {
            word = word.replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
        return imports;
    }

    @Override
    protected Map<String, String> getAllAliases(Map<String, Model> allDefinitions) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        if (allDefinitions != null) {
            for (Map.Entry<String, Model> entry : allDefinitions.entrySet()) {
                ModelImpl impl;
                String swaggerName = entry.getKey();
                Model m = entry.getValue();
                if (m instanceof ModelImpl && (impl = (ModelImpl)m).getType() != null && !impl.getType().equals("object") && impl.getEnum() == null) {
                    aliases.put(swaggerName, impl.getType());
                }
                if (!(m instanceof ArrayModel)) continue;
                impl = (ArrayModel)m;
                aliases.put(swaggerName, impl.getType());
            }
        }
        return aliases;
    }

    @Override
    protected void addParentContainer(CodegenModel m, String name, Property property) {
        String mappedType;
        m.parentContainer = this.fromProperty(name, property);
        this.addImport(m, m.parentContainer.complexType);
        m.parent = this.toInstantiationType(property);
        String containerType = m.parentContainer.containerType;
        String instantiationType = (String)this.instantiationTypes.get(containerType);
        if (instantiationType != null && !m.isArrayModel) {
            this.addImport(m, instantiationType);
        }
        if ((mappedType = (String)this.typeMapping.get(containerType)) != null) {
            this.addImport(m, mappedType);
        }
    }
}

