/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.AbstractBuildContext;
import io.takari.incrementalbuild.spi.BuildContextEnvironment;
import io.takari.incrementalbuild.spi.BuildContextFinalizer;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultResource;
import io.takari.incrementalbuild.spi.DefaultResourceMetadata;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class DefaultBuildContext
extends AbstractBuildContext
implements BuildContext {
    public DefaultBuildContext(BuildContextEnvironment configuration) {
        super(configuration);
    }

    protected DefaultBuildContext(Workspace workspace, File stateFile, Map<String, Serializable> configuration, BuildContextFinalizer finalizer) {
        super(workspace, stateFile, configuration, finalizer);
    }

    @Override
    public Collection<DefaultResource<File>> registerAndProcessInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        return super.registerAndProcessInputs(basedir, includes, excludes);
    }

    @Override
    protected void finalizeContext() throws IOException {
        HashSet<File> uptodateOldOutputs = new HashSet<File>();
        for (Object resource : this.oldState.getResources().keySet()) {
            if (this.oldState.isOutput(resource) || this.isProcessedResource(resource) || this.isDeletedResource(resource) || !this.isRegisteredResource(resource)) continue;
            if (this.state.isOutput(resource)) {
                throw new IllegalStateException("Inconsistent resource type change " + resource);
            }
            this.state.putResource(resource, this.oldState.getResource(resource));
            this.state.setResourceMessages(resource, this.oldState.getResourceMessages(resource));
            this.state.setResourceAttributes(resource, this.oldState.getResourceAttributes(resource));
            Collection<File> oldOutputs = this.oldState.getResourceOutputs(resource);
            this.state.setResourceOutputs(resource, oldOutputs);
            if (oldOutputs == null) continue;
            uptodateOldOutputs.addAll(oldOutputs);
        }
        for (File output : uptodateOldOutputs) {
            if (this.state.isResource(output)) {
                throw new IllegalStateException("Can't carry over " + output);
            }
            this.state.putResource(output, this.oldState.getResource(output));
            this.state.addOutput(output);
            this.state.setResourceMessages(output, this.oldState.getResourceMessages(output));
            this.state.setResourceAttributes(output, this.oldState.getResourceAttributes(output));
        }
        for (File output : this.oldState.getOutputs()) {
            if (this.state.isOutput(output)) continue;
            this.deleteOutput(output);
        }
    }

    @Override
    public void markSkipExecution() {
        super.markSkipExecution();
    }

    @Override
    public DefaultResourceMetadata<File> registerInput(File inputFile) {
        return super.registerInput(inputFile);
    }

    @Override
    public Collection<DefaultResourceMetadata<File>> registerInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        return super.registerInputs(basedir, includes, excludes);
    }

    @Override
    protected void assertAssociation(DefaultResource<?> resource, DefaultOutput output) {
        Object input = resource.getResource();
        File outputFile = (File)output.getResource();
        if (this.state.isOutput(input)) {
            throw new UnsupportedOperationException();
        }
        Collection<Object> inputs = this.state.getOutputInputs(outputFile);
        if (inputs != null && !inputs.isEmpty() && !DefaultBuildContext.containsOnly(inputs, input)) {
            throw new UnsupportedOperationException();
        }
    }

    private static boolean containsOnly(Collection<Object> collection, Object element) {
        for (Object other : collection) {
            if (element.equals(other)) continue;
            return true;
        }
        return true;
    }
}

