/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.takari.incrementalbuild.Incremental;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.install_deploy.DeployParticipant;
import io.takari.maven.plugins.util.AetherUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, configurator="takari")
public class Deploy
extends TakariLifecycleMojo {
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="false", property="deployAtEnd")
    protected boolean deployAtEnd;
    @Inject
    private DeployParticipant deployParticipant;

    @Override
    public void executeMojo() throws MojoExecutionException {
        this.installProject(this.project);
    }

    private void installProject(MavenProject project) throws MojoExecutionException {
        Artifact artifact;
        DeployRequest deployRequest = new DeployRequest();
        if ("pom".equals(project.getPackaging())) {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            artifact = artifact.setFile(project.getFile());
            deployRequest.addArtifact(artifact);
        } else {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            deployRequest.addArtifact(artifact);
            SubArtifact pomArtifact = new SubArtifact(artifact, "", "pom");
            pomArtifact = pomArtifact.setFile(project.getFile());
            deployRequest.addArtifact((Artifact)pomArtifact);
        }
        for (org.apache.maven.artifact.Artifact attachedArtifact : project.getAttachedArtifacts()) {
            deployRequest.addArtifact(AetherUtils.toArtifact(attachedArtifact));
        }
        deployRequest.setRepository(this.remoteRepository(project));
        if (!this.deployAtEnd) {
            try {
                this.deployParticipant.deploy(this.repositorySystemSession, deployRequest);
            }
            catch (DeploymentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)("Will deploy " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + " at the end of build"));
            this.deployParticipant.deployAtEnd(deployRequest);
        }
    }

    public RemoteRepository remoteRepository(MavenProject project) throws MojoExecutionException {
        if (this.altDeploymentRepository != null) {
            Matcher matcher = Pattern.compile("(.+)::(.+)::(.+)").matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoExecutionException((Object)this.altDeploymentRepository, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            RemoteRepository.Builder builder = new RemoteRepository.Builder(id, layout, url);
            return builder.build();
        }
        return AetherUtils.toRepo(project.getDistributionManagementArtifactRepository());
    }
}

