/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Repository;
import org.apache.maven.repository.Proxy;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class AetherUtils {
    private static String nullify(String string) {
        return string == null || string.length() <= 0 ? null : string;
    }

    private static org.apache.maven.artifact.Artifact toArtifact(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact result = AetherUtils.toArtifact(dependency.getArtifact());
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    public static org.apache.maven.artifact.Artifact toArtifact(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        ArtifactHandler handler = AetherUtils.newHandler(artifact);
        org.apache.maven.artifact.DefaultArtifact result = new org.apache.maven.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getProperty("type", artifact.getExtension()), AetherUtils.nullify(artifact.getClassifier()), handler);
        result.setFile(artifact.getFile());
        result.setResolved(artifact.getFile() != null);
        ArrayList<String> trail = new ArrayList<String>(1);
        trail.add(result.getId());
        result.setDependencyTrail(trail);
        return result;
    }

    public static void toArtifacts(Collection<org.apache.maven.artifact.Artifact> artifacts, Collection<? extends DependencyNode> nodes, List<String> trail, DependencyFilter filter) {
        for (DependencyNode dependencyNode : nodes) {
            org.apache.maven.artifact.Artifact artifact = AetherUtils.toArtifact(dependencyNode.getDependency());
            ArrayList<String> nodeTrail = new ArrayList<String>(trail.size() + 1);
            nodeTrail.addAll(trail);
            nodeTrail.add(artifact.getId());
            if (filter == null || filter.accept(dependencyNode, Collections.emptyList())) {
                artifact.setDependencyTrail(nodeTrail);
                artifacts.add(artifact);
            }
            AetherUtils.toArtifacts(artifacts, dependencyNode.getChildren(), nodeTrail, filter);
        }
    }

    public static Artifact toArtifact(org.apache.maven.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String version = artifact.getVersion();
        if (version == null && artifact.getVersionRange() != null) {
            version = artifact.getVersionRange().toString();
        }
        Map<String, String> props = null;
        if ("system".equals(artifact.getScope())) {
            String localPath = artifact.getFile() != null ? artifact.getFile().getPath() : "";
            props = Collections.singletonMap("localPath", localPath);
        }
        DefaultArtifact result = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), version, props, AetherUtils.newArtifactType(artifact.getType(), artifact.getArtifactHandler()));
        result = result.setFile(artifact.getFile());
        return result;
    }

    public static Dependency toDependency(org.apache.maven.artifact.Artifact artifact, Collection<Exclusion> exclusions) {
        if (artifact == null) {
            return null;
        }
        Artifact result = AetherUtils.toArtifact(artifact);
        ArrayList<org.eclipse.aether.graph.Exclusion> excl = null;
        if (exclusions != null) {
            excl = new ArrayList<org.eclipse.aether.graph.Exclusion>(exclusions.size());
            for (Exclusion exclusion : exclusions) {
                excl.add(AetherUtils.toExclusion(exclusion));
            }
        }
        return new Dependency(result, artifact.getScope(), Boolean.valueOf(artifact.isOptional()), excl);
    }

    public static List<RemoteRepository> toRepos(List<ArtifactRepository> repos) {
        if (repos == null) {
            return null;
        }
        ArrayList<RemoteRepository> results = new ArrayList<RemoteRepository>(repos.size());
        for (ArtifactRepository repo : repos) {
            results.add(AetherUtils.toRepo(repo));
        }
        return results;
    }

    public static RemoteRepository toRepo(ArtifactRepository repo) {
        RemoteRepository result = null;
        if (repo != null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), AetherUtils.getLayout(repo), repo.getUrl());
            builder.setSnapshotPolicy(AetherUtils.toPolicy(repo.getSnapshots()));
            builder.setReleasePolicy(AetherUtils.toPolicy(repo.getReleases()));
            builder.setAuthentication(AetherUtils.toAuthentication(repo.getAuthentication()));
            builder.setProxy(AetherUtils.toProxy(repo.getProxy()));
            builder.setMirroredRepositories(AetherUtils.toRepos(repo.getMirroredRepositories()));
            result = builder.build();
        }
        return result;
    }

    public static String getLayout(ArtifactRepository repo) {
        try {
            return repo.getLayout().getId();
        }
        catch (LinkageError linkageError) {
            String layout;
            String className = repo.getLayout().getClass().getSimpleName();
            if (className.endsWith("RepositoryLayout") && (layout = className.substring(0, className.length() - "RepositoryLayout".length())).length() > 0) {
                layout = String.valueOf(Character.toLowerCase(layout.charAt(0))) + layout.substring(1);
                return layout;
            }
            return "";
        }
    }

    private static RepositoryPolicy toPolicy(ArtifactRepositoryPolicy policy) {
        RepositoryPolicy result = null;
        if (policy != null) {
            result = new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
        }
        return result;
    }

    private static org.eclipse.aether.repository.Authentication toAuthentication(Authentication auth) {
        org.eclipse.aether.repository.Authentication result = null;
        if (auth != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(auth.getUsername()).addPassword(auth.getPassword());
            authBuilder.addPrivateKey(auth.getPrivateKey(), auth.getPassphrase());
            result = authBuilder.build();
        }
        return result;
    }

    private static org.eclipse.aether.repository.Proxy toProxy(Proxy proxy) {
        org.eclipse.aether.repository.Proxy result = null;
        if (proxy != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUserName()).addPassword(proxy.getPassword());
            result = new org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build());
        }
        return result;
    }

    public static ArtifactHandler newHandler(Artifact artifact) {
        String type = artifact.getProperty("type", artifact.getExtension());
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        handler.setExtension(artifact.getExtension());
        handler.setLanguage(artifact.getProperty("language", null));
        handler.setAddedToClasspath(Boolean.parseBoolean(artifact.getProperty("constitutesBuildPath", "")));
        handler.setIncludesDependencies(Boolean.parseBoolean(artifact.getProperty("includesDependencies", "")));
        return handler;
    }

    public static ArtifactType newArtifactType(String id, ArtifactHandler handler) {
        return new DefaultArtifactType(id, handler.getExtension(), handler.getClassifier(), handler.getLanguage(), handler.isAddedToClasspath(), handler.isIncludesDependencies());
    }

    public static Dependency toDependency(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<org.eclipse.aether.graph.Exclusion> exclusions = new ArrayList<org.eclipse.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(AetherUtils.toExclusion(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), exclusions);
        return result;
    }

    private static org.eclipse.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    public static ArtifactTypeRegistry newArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
        return new MavenArtifactTypeRegistry(handlerManager);
    }

    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
        }
        return pomArtifact;
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
        builder.setSnapshotPolicy(AetherUtils.toRepositoryPolicy(repository.getSnapshots()));
        builder.setReleasePolicy(AetherUtils.toRepositoryPolicy(repository.getReleases()));
        return builder.build();
    }

    public static RepositoryPolicy toRepositoryPolicy(org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    static class MavenArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        private final ArtifactHandlerManager handlerManager;

        public MavenArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
            this.handlerManager = handlerManager;
        }

        public ArtifactType get(String stereotypeId) {
            ArtifactHandler handler = this.handlerManager.getArtifactHandler(stereotypeId);
            return AetherUtils.newArtifactType(stereotypeId, handler);
        }
    }
}

