/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.maven.plugins.compile.javac.FileObjects;
import io.takari.maven.plugins.compile.javac.IncrementalFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

abstract class RecordingJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final Charset encoding;

    protected RecordingJavaFileManager(StandardJavaFileManager fileManager, Charset encoding) {
        super(fileManager);
        this.encoding = encoding;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, final FileObject sibling) throws IOException {
        FileObject fileObject = super.getFileForOutput(location, packageName, relativeName, sibling);
        return new ForwardingFileObject<FileObject>(fileObject){

            @Override
            public OutputStream openOutputStream() throws IOException {
                RecordingJavaFileManager.this.record(sibling != null ? FileObjects.toFile(sibling) : null, FileObjects.toFile(this.fileObject));
                return new IncrementalFileOutputStream(FileObjects.toFile(this));
            }

            @Override
            public Writer openWriter() throws IOException {
                return RecordingJavaFileManager.this.encoding != null ? new OutputStreamWriter(this.openOutputStream(), RecordingJavaFileManager.this.encoding) : new OutputStreamWriter(this.openOutputStream());
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, final FileObject sibling) throws IOException {
        JavaFileObject fileObject = super.getJavaFileForOutput(location, className, kind, sibling);
        return new ForwardingJavaFileObject<JavaFileObject>(fileObject){

            @Override
            public OutputStream openOutputStream() throws IOException {
                RecordingJavaFileManager.this.record(sibling != null ? FileObjects.toFile(sibling) : null, FileObjects.toFile(this.fileObject));
                return new IncrementalFileOutputStream(FileObjects.toFile(this));
            }

            @Override
            public Writer openWriter() throws IOException {
                return RecordingJavaFileManager.this.encoding != null ? new OutputStreamWriter(this.openOutputStream(), RecordingJavaFileManager.this.encoding) : new OutputStreamWriter(this.openOutputStream());
            }
        };
    }

    protected abstract void record(File var1, File var2);

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }
}

