/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TestResources
extends TestWatcher {
    private final String projectsDir;
    private final String workDir;
    private String name;

    public TestResources() {
        this("src/test/projects", "target/test-projects");
    }

    public TestResources(String projectsDir, String workDir) {
        this.projectsDir = projectsDir;
        this.workDir = workDir;
    }

    protected void starting(Description d) {
        String methodName = d.getMethodName();
        if (methodName != null) {
            methodName = methodName.replace('/', '_').replace('\\', '_');
        }
        this.name = String.valueOf(d.getTestClass().getSimpleName()) + "_" + methodName;
    }

    public File getBasedir(String project) throws IOException {
        if (this.name == null) {
            throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " must be a test class field annotated with org.junit.Rule");
        }
        File basedir = new File(this.workDir, String.valueOf(this.name) + "_" + project).getCanonicalFile();
        FileUtils.deleteDirectory((File)basedir);
        Assert.assertTrue((String)"Test project working directory created", (boolean)basedir.mkdirs());
        File src = new File(this.projectsDir, project).getCanonicalFile();
        Assert.assertTrue((String)("Test project directory does not exist: " + src.getPath()), (boolean)src.isDirectory());
        FileUtils.copyDirectoryStructure((File)src, (File)basedir);
        return basedir;
    }

    public File getBasedir() throws IOException {
        if (this.name == null) {
            throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " must be a test class field annotated with org.junit.Rule");
        }
        File basedir = new File(this.workDir, this.name).getCanonicalFile();
        FileUtils.deleteDirectory((File)basedir);
        Assert.assertTrue((String)"Test project working directory created", (boolean)basedir.mkdirs());
        return basedir;
    }

    public static void cp(File basedir, String from, String to) throws IOException {
        FileUtils.copyFile((File)new File(basedir, from), (File)new File(basedir, to));
    }

    public static void assertFileContents(File basedir, String expectedPath, String actualPath) throws IOException {
        String expected = TestResources.fileRead(new File(basedir, expectedPath), true);
        String actual = TestResources.fileRead(new File(basedir, actualPath), true);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * Unable to fully structure code
     */
    private static String fileRead(File file, boolean normalizeEOL) throws IOException {
        block11: {
            sb = new StringBuilder();
            var3_3 = null;
            var4_5 = null;
            try {
                r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                try {
                    if (!normalizeEOL) ** GOTO lbl15
                    while ((str = r.readLine()) != null) {
                        sb.append(str).append('\n');
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        sb.append((char)ch);
lbl15:
                        // 2 sources

                        ** while ((ch = r.read()) != -1)
                    }
lbl16:
                    // 1 sources

                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                throw var3_3;
            }
        }
        return sb.toString();
    }

    public static void assertFileContents(String expectedContents, File basedir, String path) throws IOException {
        String actualContents = TestResources.fileRead(new File(basedir, path), true);
        Assert.assertEquals((Object)expectedContents, (Object)actualContents);
    }

    public static void assertDirectoryContents(File dir, String ... expectedPaths) {
        String path;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.addDefaultExcludes();
        scanner.scan();
        TreeSet<String> actual = new TreeSet<String>();
        String[] stringArray = scanner.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            actual.add(path);
            ++n2;
        }
        stringArray = scanner.getIncludedDirectories();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            if (path.length() > 0) {
                actual.add(String.valueOf(path) + "/");
            }
            ++n2;
        }
        TreeSet<String> expected = new TreeSet<String>();
        if (expectedPaths != null) {
            String[] stringArray2 = expectedPaths;
            int n3 = expectedPaths.length;
            n = 0;
            while (n < n3) {
                String path2 = stringArray2[n];
                expected.add(path2);
                ++n;
            }
        }
        Assert.assertEquals((Object)TestResources.toString(expected), (Object)TestResources.toString(actual));
    }

    private static String toString(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append('\n');
        }
        return sb.toString();
    }

    public static void touch(File basedir, String path) throws InterruptedException {
        TestResources.touch(new File(basedir, path));
    }

    public static void touch(File file) throws InterruptedException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file " + file);
        }
        long lastModified = file.lastModified();
        file.setLastModified(System.currentTimeMillis());
        if (lastModified == file.lastModified()) {
            Thread.sleep(1000L);
            file.setLastModified(System.currentTimeMillis());
        }
    }

    public static void rm(File basedir, String path) {
        Assert.assertTrue((String)("delete " + path), (boolean)new File(basedir, path).delete());
    }

    public static void create(File basedir, String ... paths) throws IOException {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(basedir, path);
            file.getParentFile().mkdirs();
            Assert.assertTrue((boolean)file.getParentFile().isDirectory());
            file.createNewFile();
            Assert.assertTrue((file.isFile() && file.canRead() ? 1 : 0) != 0);
            ++n2;
        }
    }

    public static void assertFilesPresent(File basedir, String ... paths) {
        if (basedir == null || paths == null || paths.length <= 0) {
            throw new IllegalArgumentException();
        }
        if (paths.length == 1) {
            Assert.assertTrue((String)(String.valueOf(paths[0]) + " PRESENT"), (boolean)new File(basedir, paths[0]).isFile());
        } else {
            StringBuilder expected = new StringBuilder();
            StringBuilder actual = new StringBuilder();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                expected.append(path).append("\n");
                if (!new File(basedir, path).isFile()) {
                    actual.append("NOT PRESENT ");
                }
                actual.append(path).append("\n");
                ++n2;
            }
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        }
    }

    public static void assertFilesNotPresent(File basedir, String ... paths) {
        if (basedir == null || paths == null || paths.length <= 0) {
            throw new IllegalArgumentException();
        }
        if (paths.length == 1) {
            Assert.assertFalse((String)(String.valueOf(paths[0]) + " NOT PRESENT"), (boolean)new File(basedir, paths[0]).isFile());
        } else {
            StringBuilder expected = new StringBuilder();
            StringBuilder actual = new StringBuilder();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                expected.append(path).append("\n");
                if (new File(basedir, path).isFile()) {
                    actual.append("PRESENT ");
                }
                actual.append(path).append("\n");
                ++n2;
            }
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        }
    }

    public static Map<String, String> readProperties(File basedir, String path) throws IOException {
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(new File(basedir, path));){
            properties.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            result.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(result);
    }
}

