/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;

public class SecurityInitialHandler
implements HttpHandler {
    private final AuthenticationMode authenticationMode;
    private final IdentityManager identityManager;
    private final HttpHandler next;

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, HttpHandler next) {
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        SecurityContextImpl newContext = new SecurityContextImpl(exchange, this.authenticationMode, this.identityManager);
        exchange.putAttachment(SecurityContext.ATTACHMENT_KEY, newContext);
        HttpHandlers.executeHandler(this.next, exchange);
    }
}

