/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import java.io.Closeable;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

public class EagerFormParsingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(final HttpServerExchange exchange) {
        FormDataParser parser = exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
        if (parser == null) {
            HttpHandlers.executeHandler(this.next, exchange);
            return;
        }
        IoFuture<FormData> future = parser.parse();
        future.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<FormData, Object>(){

            public void notify(IoFuture<? extends FormData> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                    HttpHandlers.executeHandler(EagerFormParsingHandler.this.next, exchange);
                } else if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    UndertowLogger.REQUEST_LOGGER.ioExceptionReadingFromChannel(ioFuture.getException());
                    IoUtils.safeClose((Closeable)exchange.getRequestChannel());
                    exchange.endExchange();
                }
            }
        }, null);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EagerFormParsingHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

