/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Base64;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;

public class Hybi07Handshake
extends Handshake {
    protected final boolean allowExtensions;

    protected Hybi07Handshake(WebSocketVersion version, Set<String> subprotocols, boolean allowExtensions) {
        super(version, "SHA1", "258EAFA5-E914-47DA-95CA-C5AB0DC85B11", subprotocols);
        this.allowExtensions = allowExtensions;
    }

    public Hybi07Handshake(Set<String> subprotocols, boolean allowExtensions) {
        this(WebSocketVersion.V07, subprotocols, allowExtensions);
    }

    public Hybi07Handshake() {
        this(WebSocketVersion.V07, Collections.emptySet(), false);
    }

    @Override
    public boolean matches(WebSocketHttpExchange exchange) {
        if (exchange.getRequestHeader("Sec-WebSocket-Key") != null && exchange.getRequestHeader("Sec-WebSocket-Version") != null) {
            return exchange.getRequestHeader("Sec-WebSocket-Version").equals(this.getVersion().toHttpHeaderValue());
        }
        return false;
    }

    @Override
    protected void handshakeInternal(WebSocketHttpExchange exchange) {
        String protocol;
        String origin = exchange.getRequestHeader("Sec-WebSocket-Origin");
        if (origin != null) {
            exchange.setResponseHeader("Sec-WebSocket-Origin", origin);
        }
        if ((protocol = exchange.getRequestHeader("Sec-WebSocket-Protocol")) != null) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", protocol);
        }
        exchange.setResponseHeader("Sec-WebSocket-Location", Hybi07Handshake.getWebSocketLocation(exchange));
        String key = exchange.getRequestHeader("Sec-WebSocket-Key");
        try {
            String solution = this.solve(key);
            exchange.setResponseHeader("Sec-WebSocket-Accept", solution);
            this.performUpgrade(exchange);
        }
        catch (NoSuchAlgorithmException e) {
            IoUtils.safeClose((Closeable)exchange);
            exchange.endExchange();
            return;
        }
    }

    protected final String solve(String nonceBase64) throws NoSuchAlgorithmException {
        String concat = nonceBase64.trim() + this.getMagicNumber();
        MessageDigest digest = MessageDigest.getInstance(this.getHashAlgorithm());
        digest.update(concat.getBytes(WebSocketUtils.UTF_8));
        String result = Base64.encodeBytes(digest.digest()).trim();
        return result;
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, ConnectedStreamChannel channel, Pool<ByteBuffer> pool) {
        return new WebSocket07Channel(channel, pool, Hybi07Handshake.getWebSocketLocation(exchange), this.subprotocols, this.allowExtensions);
    }
}

