/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatusCodes {
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMENANTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIME_OUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LARGE = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUEST_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIME_OUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final String CONTINUE_STRING = "Continue";
    public static final String SWITCHING_PROTOCOLS_STRING = "Switching Protocols";
    public static final String OK_STRING = "OK";
    public static final String CREATED_STRING = "Created";
    public static final String ACCEPTED_STRING = "Accepted";
    public static final String NON_AUTHORITATIVE_INFORMATION_STRING = "Non-Authoritative Information";
    public static final String NO_CONTENT_STRING = "No Content";
    public static final String RESET_CONTENT_STRING = "Reset Content";
    public static final String PARTIAL_CONTENT_STRING = "Partial Content";
    public static final String MULTIPLE_CHOICES_STRING = "Multiple Choices";
    public static final String MOVED_PERMENANTLY_STRING = "Moved Permanently";
    public static final String FOUND_STRING = "Found";
    public static final String SEE_OTHER_STRING = "See Other";
    public static final String NOT_MODIFIED_STRING = "Not Modified";
    public static final String USE_PROXY_STRING = "Use Proxy";
    public static final String TEMPORARY_REDIRECT_STRING = "Temporary Redirect";
    public static final String BAD_REQUEST_STRING = "Bad Request";
    public static final String UNAUTHORIZED_STRING = "Unauthorized";
    public static final String PAYMENT_REQUIRED_STRING = "Payment Required";
    public static final String FORBIDDEN_STRING = "Forbidden";
    public static final String NOT_FOUND_STRING = "Not Found";
    public static final String METHOD_NOT_ALLOWED_STRING = "Method Not Allowed";
    public static final String NOT_ACCEPTABLE_STRING = "Not Acceptable";
    public static final String PROXY_AUTHENTICATION_REQUIRED_STRING = "Proxy Authentication Required";
    public static final String REQUEST_TIME_OUT_STRING = "Request Time-out";
    public static final String CONFLICT_STRING = "Conflict";
    public static final String GONE_STRING = "Gone";
    public static final String LENGTH_REQUIRED_STRING = "Length Required";
    public static final String PRECONDITION_FAILED_STRING = "Precondition Failed";
    public static final String REQUEST_ENTITY_TOO_LARGE_STRING = "Request Entity Too Large";
    public static final String REQUEST_URI_TOO_LARGE_STRING = "Request-URI Too Large";
    public static final String UNSUPPORTED_MEDIA_TYPE_STRING = "Unsupported Media Type";
    public static final String REQUEST_RANGE_NOT_SATISFIABLE_STRING = "Requested range not satisfiable";
    public static final String EXPECTATION_FAILED_STRING = "Expectation Failed";
    public static final String INTERNAL_SERVER_ERROR_STRING = "Internal Server Error";
    public static final String NOT_IMPLEMENTED_STRING = "Not Implemented";
    public static final String BAD_GATEWAY_STRING = "Bad Gateway";
    public static final String SERVICE_UNAVAILABLE_STRING = "Service Unavailable";
    public static final String GATEWAY_TIME_OUT_STRING = "Gateway Time-out";
    public static final String HTTP_VERSION_NOT_SUPPORTED_STRING = "HTTP Version not supported";
    private static final Map<Integer, String> CODES;

    private StatusCodes() {
    }

    public static final String getReason(int code) {
        String result = CODES.get(code);
        if (result == null) {
            return "Unknown";
        }
        return result;
    }

    static {
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        codes.put(100, CONTINUE_STRING);
        codes.put(101, SWITCHING_PROTOCOLS_STRING);
        codes.put(200, OK_STRING);
        codes.put(201, CREATED_STRING);
        codes.put(202, ACCEPTED_STRING);
        codes.put(203, NON_AUTHORITATIVE_INFORMATION_STRING);
        codes.put(204, NO_CONTENT_STRING);
        codes.put(205, RESET_CONTENT_STRING);
        codes.put(206, PARTIAL_CONTENT_STRING);
        codes.put(300, MULTIPLE_CHOICES_STRING);
        codes.put(301, MOVED_PERMENANTLY_STRING);
        codes.put(302, FOUND_STRING);
        codes.put(303, SEE_OTHER_STRING);
        codes.put(304, NOT_MODIFIED_STRING);
        codes.put(305, USE_PROXY_STRING);
        codes.put(307, TEMPORARY_REDIRECT_STRING);
        codes.put(400, BAD_REQUEST_STRING);
        codes.put(401, UNAUTHORIZED_STRING);
        codes.put(402, PAYMENT_REQUIRED_STRING);
        codes.put(403, FORBIDDEN_STRING);
        codes.put(404, NOT_FOUND_STRING);
        codes.put(405, METHOD_NOT_ALLOWED_STRING);
        codes.put(406, NOT_ACCEPTABLE_STRING);
        codes.put(407, PROXY_AUTHENTICATION_REQUIRED_STRING);
        codes.put(408, REQUEST_TIME_OUT_STRING);
        codes.put(409, CONFLICT_STRING);
        codes.put(410, GONE_STRING);
        codes.put(411, LENGTH_REQUIRED_STRING);
        codes.put(412, PRECONDITION_FAILED_STRING);
        codes.put(413, REQUEST_ENTITY_TOO_LARGE_STRING);
        codes.put(414, REQUEST_URI_TOO_LARGE_STRING);
        codes.put(415, UNSUPPORTED_MEDIA_TYPE_STRING);
        codes.put(416, REQUEST_RANGE_NOT_SATISFIABLE_STRING);
        codes.put(417, EXPECTATION_FAILED_STRING);
        codes.put(500, INTERNAL_SERVER_ERROR_STRING);
        codes.put(501, NOT_IMPLEMENTED_STRING);
        codes.put(502, BAD_GATEWAY_STRING);
        codes.put(503, SERVICE_UNAVAILABLE_STRING);
        codes.put(504, GATEWAY_TIME_OUT_STRING);
        codes.put(505, HTTP_VERSION_NOT_SUPPORTED_STRING);
        CODES = Collections.unmodifiableMap(codes);
    }
}

