/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class UndertowInputStream
extends InputStream {
    private final HttpServerExchange exchange;
    private StreamSourceChannel channel;
    private boolean closed;

    public UndertowInputStream(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.channel == null) {
            this.channel = this.exchange.getRequestChannel();
        }
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.channel.awaitReadable();
        return this.channel.read(ByteBuffer.wrap(b, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.channel == null) {
            this.channel = this.exchange.getRequestChannel();
        }
        Pooled pooled = this.exchange.getConnection().getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        try {
            int res;
            do {
                this.channel.awaitReadable();
            } while ((res = this.channel.read(buffer)) != -1);
            this.channel.shutdownReads();
        }
        finally {
            pooled.free();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0];
    }
}

