/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;

public class FilterRegistrationImpl
implements FilterRegistration,
FilterRegistration.Dynamic {
    private final FilterInfo filterInfo;
    private final DeploymentInfo deploymentInfo;

    public FilterRegistrationImpl(FilterInfo filterInfo, DeploymentInfo deploymentInfo) {
        this.filterInfo = filterInfo;
        this.deploymentInfo = deploymentInfo;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        for (String servlet : servletNames) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    this.deploymentInfo.addFilterServletNameMapping(this.filterInfo.getName(), servlet, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    this.deploymentInfo.addFilterServletNameMapping(this.filterInfo.getName(), servlet, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                this.deploymentInfo.insertFilterServletNameMapping(0, this.filterInfo.getName(), servlet, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                this.deploymentInfo.insertFilterServletNameMapping(0, this.filterInfo.getName(), servlet, dispatcher);
            }
        }
    }

    public Collection<String> getServletNameMappings() {
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : this.deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        for (String url : urlPatterns) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    this.deploymentInfo.addFilterUrlMapping(this.filterInfo.getName(), url, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    this.deploymentInfo.addFilterUrlMapping(this.filterInfo.getName(), url, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                this.deploymentInfo.insertFilterUrlMapping(0, this.filterInfo.getName(), url, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                this.deploymentInfo.insertFilterUrlMapping(0, this.filterInfo.getName(), url, dispatcher);
            }
        }
    }

    public Collection<String> getUrlPatternMappings() {
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : this.deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.URL || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    public String getName() {
        return this.filterInfo.getName();
    }

    public String getClassName() {
        return this.filterInfo.getFilterClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        if (this.filterInfo.getInitParams().containsKey(name)) {
            return false;
        }
        this.filterInfo.addInitParam(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.filterInfo.getInitParams().get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public Map<String, String> getInitParameters() {
        return this.filterInfo.getInitParams();
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.filterInfo.setAsyncSupported(isAsyncSupported);
    }
}

