/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.spec.ServletOutputStreamImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Locale;

public class ServletPrintWriter {
    private final ServletOutputStreamImpl outputStream;
    private final CharsetEncoder charsetEncoder;
    private boolean error = false;

    public ServletPrintWriter(ServletOutputStreamImpl outputStream, String charset) throws UnsupportedEncodingException {
        this.outputStream = outputStream;
        this.charsetEncoder = Charset.forName(charset).newEncoder();
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public boolean checkError() {
        return this.error;
    }

    private void doWrite(CharBuffer cb) {
        ByteBuffer buffer = this.outputStream.underlyingBuffer();
        try {
            if (!buffer.hasRemaining()) {
                this.outputStream.flush();
            }
            while (cb.hasRemaining()) {
                int remaining = buffer.remaining();
                CoderResult result = this.charsetEncoder.encode(cb, buffer, false);
                this.outputStream.updateWritten(remaining - buffer.remaining());
                if (!result.isOverflow()) continue;
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public void write(int c) {
        CharBuffer cb = CharBuffer.wrap(Character.toString((char)c));
        this.doWrite(cb);
    }

    public void write(char[] buf, int off, int len) {
        CharBuffer cb = CharBuffer.wrap(buf, off, len);
        this.doWrite(cb);
    }

    public void write(char[] buf) {
        CharBuffer cb = CharBuffer.wrap(buf);
        this.doWrite(cb);
    }

    public void write(String s, int off, int len) {
        CharBuffer cb = CharBuffer.wrap(s, off, len);
        this.doWrite(cb);
    }

    public void write(String s) {
        CharBuffer cb = CharBuffer.wrap(s);
        this.doWrite(cb);
    }

    public void print(boolean b) {
        CharBuffer cb = CharBuffer.wrap(Boolean.toString(b));
        this.doWrite(cb);
    }

    public void print(char c) {
        CharBuffer cb = CharBuffer.wrap(Character.toString(c));
        this.doWrite(cb);
    }

    public void print(int i) {
        CharBuffer cb = CharBuffer.wrap(Integer.toString(i));
        this.doWrite(cb);
    }

    public void print(long l) {
        CharBuffer cb = CharBuffer.wrap(Long.toString(l));
        this.doWrite(cb);
    }

    public void print(float f) {
        CharBuffer cb = CharBuffer.wrap(Float.toString(f));
        this.doWrite(cb);
    }

    public void print(double d) {
        CharBuffer cb = CharBuffer.wrap(Double.toString(d));
        this.doWrite(cb);
    }

    public void print(char[] s) {
        CharBuffer cb = CharBuffer.wrap(s);
        this.doWrite(cb);
    }

    public void print(String s) {
        CharBuffer cb = CharBuffer.wrap(s);
        this.doWrite(cb);
    }

    public void print(Object obj) {
        CharBuffer cb = CharBuffer.wrap(obj == null ? "null" : obj.toString());
        this.doWrite(cb);
    }

    public void println() {
        CharBuffer cb = CharBuffer.wrap("\n");
        this.doWrite(cb);
    }

    public void println(boolean b) {
        CharBuffer cb = CharBuffer.wrap(Boolean.toString(b) + "\n");
        this.doWrite(cb);
    }

    public void println(char c) {
        CharBuffer cb = CharBuffer.wrap(Character.toString(c) + "\n");
        this.doWrite(cb);
    }

    public void println(int i) {
        CharBuffer cb = CharBuffer.wrap(Integer.toString(i) + "\n");
        this.doWrite(cb);
    }

    public void println(long l) {
        CharBuffer cb = CharBuffer.wrap(Long.toString(l) + "\n");
        this.doWrite(cb);
    }

    public void println(float f) {
        CharBuffer cb = CharBuffer.wrap(Float.toString(f) + "\n");
        this.doWrite(cb);
    }

    public void println(double d) {
        CharBuffer cb = CharBuffer.wrap(Double.toString(d) + "\n");
        this.doWrite(cb);
    }

    public void println(char[] s) {
        CharBuffer cb = CharBuffer.wrap(s + "\n");
        this.doWrite(cb);
    }

    public void println(String s) {
        CharBuffer cb = CharBuffer.wrap(s + "\n");
        this.doWrite(cb);
    }

    public void println(Object obj) {
        CharBuffer cb = CharBuffer.wrap(obj == null ? "null\n" : obj.toString() + "\n");
        this.doWrite(cb);
    }

    public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    public void printf(Locale l, String format, Object ... args) {
        this.print(String.format(l, format, args));
    }

    public void format(String format, Object ... args) {
        this.printf(format, args);
    }

    public void format(Locale l, String format, Object ... args) {
        this.printf(l, format, args);
    }

    public void append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
    }

    public void append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
    }

    public void append(char c) {
        this.write(c);
    }
}

