/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.TxnError;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.impl.KVParser;

class TxnResponseParser {
    TxnResponseParser() {
    }

    static TxnResponse parse(JsonObject json) {
        TxnResponse response = new TxnResponse();
        if (json.getValue("Results") instanceof JsonArray) {
            json.getJsonArray("Results").forEach(entry -> {
                JsonObject obj = (JsonObject)entry;
                if (obj.containsKey("KV")) {
                    response.addResult(KVParser.parse(obj.getJsonObject("KV")));
                }
            });
        }
        if (json.getValue("Errors") instanceof JsonArray) {
            json.getJsonArray("Errors").forEach(entry -> {
                JsonObject obj = (JsonObject)entry;
                response.addError(new TxnError().setOpIndex(obj.getInteger("OpIndex")).setWhat(obj.getString("What")));
            });
        }
        return response;
    }
}

