/*
 * Copyright (c) 2011-2017 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package io.vertx.core.http.impl;

import java.util.HashMap;
import java.util.Map;

/**
 * We do our own mapping since support for mime mapping in Java is platform dependent
 * and doesn't seem to work very well
 *
 * @author <a href="http://tfox.org">Tim Fox</a>
 */
public class MimeMapping {
  private static final Map<String, String> m = new HashMap<>();

  static {
    m.put("ez", "application/andrew-inset");
    m.put("aw", "application/applixware");
    m.put("atom", "application/atom+xml");
    m.put("atomcat", "application/atomcat+xml");
    m.put("atomsvc", "application/atomsvc+xml");
    m.put("ccxml", "application/ccxml+xml");
    m.put("cdmia", "application/cdmi-capability");
    m.put("cdmic", "application/cdmi-container");
    m.put("cdmid", "application/cdmi-domain");
    m.put("cdmio", "application/cdmi-object");
    m.put("cdmiq", "application/cdmi-queue");
    m.put("cu", "application/cu-seeme");
    m.put("davmount", "application/davmount+xml");
    m.put("dbk", "application/docbook+xml");
    m.put("dssc", "application/dssc+der");
    m.put("xdssc", "application/dssc+xml");
    m.put("ecma", "application/ecmascript");
    m.put("emma", "application/emma+xml");
    m.put("epub", "application/epub+zip");
    m.put("exi", "application/exi");
    m.put("pfr", "application/font-tdpfr");
    m.put("gml", "application/gml+xml");
    m.put("gpx", "application/gpx+xml");
    m.put("gxf", "application/gxf");
    m.put("stk", "application/hyperstudio");
    m.put("ink", "application/inkml+xml");
    m.put("inkml", "application/inkml+xml");
    m.put("ipfix", "application/ipfix");
    m.put("jar", "application/java-archive");
    m.put("ser", "application/java-serialized-object");
    m.put("class", "application/java-vm");
    m.put("js", "application/javascript");
    m.put("json", "application/json");
    m.put("jsonml", "application/jsonml+json");
    m.put("lostxml", "application/lost+xml");
    m.put("hqx", "application/mac-binhex40");
    m.put("cpt", "application/mac-compactpro");
    m.put("mads", "application/mads+xml");
    m.put("mrc", "application/marc");
    m.put("mrcx", "application/marcxml+xml");
    m.put("ma", "application/mathematica");
    m.put("nb", "application/mathematica");
    m.put("mb", "application/mathematica");
    m.put("mathml", "application/mathml+xml");
    m.put("mbox", "application/mbox");
    m.put("mscml", "application/mediaservercontrol+xml");
    m.put("metalink", "application/metalink+xml");
    m.put("meta4", "application/metalink4+xml");
    m.put("mets", "application/mets+xml");
    m.put("mods", "application/mods+xml");
    m.put("m21", "application/mp21");
    m.put("mp21", "application/mp21");
    m.put("mp4s", "application/mp4");
    m.put("doc", "application/msword");
    m.put("dot", "application/msword");
    m.put("mxf", "application/mxf");
    m.put("bin", "application/octet-stream");
    m.put("dms", "application/octet-stream");
    m.put("lrf", "application/octet-stream");
    m.put("mar", "application/octet-stream");
    m.put("so", "application/octet-stream");
    m.put("dist", "application/octet-stream");
    m.put("distz", "application/octet-stream");
    m.put("pkg", "application/octet-stream");
    m.put("bpk", "application/octet-stream");
    m.put("dump", "application/octet-stream");
    m.put("elc", "application/octet-stream");
    m.put("deploy", "application/octet-stream");
    m.put("oda", "application/oda");
    m.put("opf", "application/oebps-package+xml");
    m.put("ogx", "application/ogg");
    m.put("omdoc", "application/omdoc+xml");
    m.put("onetoc", "application/onenote");
    m.put("onetoc2", "application/onenote");
    m.put("onetmp", "application/onenote");
    m.put("onepkg", "application/onenote");
    m.put("oxps", "application/oxps");
    m.put("xer", "application/patch-ops-error+xml");
    m.put("pdf", "application/pdf");
    m.put("pgp", "application/pgp-encrypted");
    m.put("asc", "application/pgp-signature");
    m.put("sig", "application/pgp-signature");
    m.put("prf", "application/pics-rules");
    m.put("p10", "application/pkcs10");
    m.put("p7m", "application/pkcs7-mime");
    m.put("p7c", "application/pkcs7-mime");
    m.put("p7s", "application/pkcs7-signature");
    m.put("p8", "application/pkcs8");
    m.put("ac", "application/pkix-attr-cert");
    m.put("cer", "application/pkix-cert");
    m.put("crl", "application/pkix-crl");
    m.put("pkipath", "application/pkix-pkipath");
    m.put("pki", "application/pkixcmp");
    m.put("pls", "application/pls+xml");
    m.put("ai", "application/postscript");
    m.put("eps", "application/postscript");
    m.put("ps", "application/postscript");
    m.put("cww", "application/prs.cww");
    m.put("pskcxml", "application/pskc+xml");
    m.put("rdf", "application/rdf+xml");
    m.put("rif", "application/reginfo+xml");
    m.put("rnc", "application/relax-ng-compact-syntax");
    m.put("rl", "application/resource-lists+xml");
    m.put("rld", "application/resource-lists-diff+xml");
    m.put("rs", "application/rls-services+xml");
    m.put("gbr", "application/rpki-ghostbusters");
    m.put("mft", "application/rpki-manifest");
    m.put("roa", "application/rpki-roa");
    m.put("rsd", "application/rsd+xml");
    m.put("rss", "application/rss+xml");
    m.put("rtf", "application/rtf");
    m.put("sbml", "application/sbml+xml");
    m.put("scq", "application/scvp-cv-request");
    m.put("scs", "application/scvp-cv-response");
    m.put("spq", "application/scvp-vp-request");
    m.put("spp", "application/scvp-vp-response");
    m.put("sdp", "application/sdp");
    m.put("setpay", "application/set-payment-initiation");
    m.put("setreg", "application/set-registration-initiation");
    m.put("shf", "application/shf+xml");
    m.put("smi", "application/smil+xml");
    m.put("smil", "application/smil+xml");
    m.put("rq", "application/sparql-query");
    m.put("srx", "application/sparql-results+xml");
    m.put("gram", "application/srgs");
    m.put("grxml", "application/srgs+xml");
    m.put("sru", "application/sru+xml");
    m.put("ssdl", "application/ssdl+xml");
    m.put("ssml", "application/ssml+xml");
    m.put("tei", "application/tei+xml");
    m.put("teicorpus", "application/tei+xml");
    m.put("tfi", "application/thraud+xml");
    m.put("tsd", "application/timestamped-data");
    m.put("plb", "application/vnd.3gpp.pic-bw-large");
    m.put("psb", "application/vnd.3gpp.pic-bw-small");
    m.put("pvb", "application/vnd.3gpp.pic-bw-var");
    m.put("tcap", "application/vnd.3gpp2.tcap");
    m.put("pwn", "application/vnd.3m.post-it-notes");
    m.put("aso", "application/vnd.accpac.simply.aso");
    m.put("imp", "application/vnd.accpac.simply.imp");
    m.put("acu", "application/vnd.acucobol");
    m.put("atc", "application/vnd.acucorp");
    m.put("acutc", "application/vnd.acucorp");
    m.put("air", "application/vnd.adobe.air-application-installer-package+zip");
    m.put("fcdt", "application/vnd.adobe.formscentral.fcdt");
    m.put("fxp", "application/vnd.adobe.fxp");
    m.put("fxpl", "application/vnd.adobe.fxp");
    m.put("xdp", "application/vnd.adobe.xdp+xml");
    m.put("xfdf", "application/vnd.adobe.xfdf");
    m.put("ahead", "application/vnd.ahead.space");
    m.put("azf", "application/vnd.airzip.filesecure.azf");
    m.put("azs", "application/vnd.airzip.filesecure.azs");
    m.put("azw", "application/vnd.amazon.ebook");
    m.put("acc", "application/vnd.americandynamics.acc");
    m.put("ami", "application/vnd.amiga.ami");
    m.put("apk", "application/vnd.android.package-archive");
    m.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
    m.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
    m.put("atx", "application/vnd.antix.game-component");
    m.put("mpkg", "application/vnd.apple.installer+xml");
    m.put("m3u8", "application/vnd.apple.mpegurl");
    m.put("swi", "application/vnd.aristanetworks.swi");
    m.put("iota", "application/vnd.astraea-software.iota");
    m.put("aep", "application/vnd.audiograph");
    m.put("mpm", "application/vnd.blueice.multipass");
    m.put("bmi", "application/vnd.bmi");
    m.put("rep", "application/vnd.businessobjects");
    m.put("cdxml", "application/vnd.chemdraw+xml");
    m.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
    m.put("cdy", "application/vnd.cinderella");
    m.put("cla", "application/vnd.claymore");
    m.put("rp9", "application/vnd.cloanto.rp9");
    m.put("c4g", "application/vnd.clonk.c4group");
    m.put("c4d", "application/vnd.clonk.c4group");
    m.put("c4f", "application/vnd.clonk.c4group");
    m.put("c4p", "application/vnd.clonk.c4group");
    m.put("c4u", "application/vnd.clonk.c4group");
    m.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
    m.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
    m.put("csp", "application/vnd.commonspace");
    m.put("cdbcmsg", "application/vnd.contact.cmsg");
    m.put("cmc", "application/vnd.cosmocaller");
    m.put("clkx", "application/vnd.crick.clicker");
    m.put("clkk", "application/vnd.crick.clicker.keyboard");
    m.put("clkp", "application/vnd.crick.clicker.palette");
    m.put("clkt", "application/vnd.crick.clicker.template");
    m.put("clkw", "application/vnd.crick.clicker.wordbank");
    m.put("wbs", "application/vnd.criticaltools.wbs+xml");
    m.put("pml", "application/vnd.ctc-posml");
    m.put("ppd", "application/vnd.cups-ppd");
    m.put("car", "application/vnd.curl.car");
    m.put("pcurl", "application/vnd.curl.pcurl");
    m.put("dart", "application/vnd.dart");
    m.put("rdz", "application/vnd.data-vision.rdz");
    m.put("uvf", "application/vnd.dece.data");
    m.put("uvvf", "application/vnd.dece.data");
    m.put("uvd", "application/vnd.dece.data");
    m.put("uvvd", "application/vnd.dece.data");
    m.put("uvt", "application/vnd.dece.ttml+xml");
    m.put("uvvt", "application/vnd.dece.ttml+xml");
    m.put("uvx", "application/vnd.dece.unspecified");
    m.put("uvvx", "application/vnd.dece.unspecified");
    m.put("uvz", "application/vnd.dece.zip");
    m.put("uvvz", "application/vnd.dece.zip");
    m.put("fe_launch", "application/vnd.denovo.fcselayout-link");
    m.put("dna", "application/vnd.dna");
    m.put("mlp", "application/vnd.dolby.mlp");
    m.put("dpg", "application/vnd.dpgraph");
    m.put("dfac", "application/vnd.dreamfactory");
    m.put("kpxx", "application/vnd.ds-keypoint");
    m.put("ait", "application/vnd.dvb.ait");
    m.put("svc", "application/vnd.dvb.service");
    m.put("geo", "application/vnd.dynageo");
    m.put("mag", "application/vnd.ecowin.chart");
    m.put("nml", "application/vnd.enliven");
    m.put("esf", "application/vnd.epson.esf");
    m.put("msf", "application/vnd.epson.msf");
    m.put("qam", "application/vnd.epson.quickanime");
    m.put("slt", "application/vnd.epson.salt");
    m.put("ssf", "application/vnd.epson.ssf");
    m.put("es3", "application/vnd.eszigno3+xml");
    m.put("et3", "application/vnd.eszigno3+xml");
    m.put("ez2", "application/vnd.ezpix-album");
    m.put("ez3", "application/vnd.ezpix-package");
    m.put("fdf", "application/vnd.fdf");
    m.put("mseed", "application/vnd.fdsn.mseed");
    m.put("seed", "application/vnd.fdsn.seed");
    m.put("dataless", "application/vnd.fdsn.seed");
    m.put("gph", "application/vnd.flographit");
    m.put("ftc", "application/vnd.fluxtime.clip");
    m.put("fm", "application/vnd.framemaker");
    m.put("frame", "application/vnd.framemaker");
    m.put("maker", "application/vnd.framemaker");
    m.put("book", "application/vnd.framemaker");
    m.put("fnc", "application/vnd.frogans.fnc");
    m.put("ltf", "application/vnd.frogans.ltf");
    m.put("fsc", "application/vnd.fsc.weblaunch");
    m.put("oas", "application/vnd.fujitsu.oasys");
    m.put("oa2", "application/vnd.fujitsu.oasys2");
    m.put("oa3", "application/vnd.fujitsu.oasys3");
    m.put("fg5", "application/vnd.fujitsu.oasysgp");
    m.put("bh2", "application/vnd.fujitsu.oasysprs");
    m.put("ddd", "application/vnd.fujixerox.ddd");
    m.put("xdw", "application/vnd.fujixerox.docuworks");
    m.put("xbd", "application/vnd.fujixerox.docuworks.binder");
    m.put("fzs", "application/vnd.fuzzysheet");
    m.put("txd", "application/vnd.genomatix.tuxedo");
    m.put("ggb", "application/vnd.geogebra.file");
    m.put("ggt", "application/vnd.geogebra.tool");
    m.put("gex", "application/vnd.geometry-explorer");
    m.put("gre", "application/vnd.geometry-explorer");
    m.put("gxt", "application/vnd.geonext");
    m.put("g2w", "application/vnd.geoplan");
    m.put("g3w", "application/vnd.geospace");
    m.put("gmx", "application/vnd.gmx");
    m.put("kml", "application/vnd.google-earth.kml+xml");
    m.put("kmz", "application/vnd.google-earth.kmz");
    m.put("gqf", "application/vnd.grafeq");
    m.put("gqs", "application/vnd.grafeq");
    m.put("gac", "application/vnd.groove-account");
    m.put("ghf", "application/vnd.groove-help");
    m.put("gim", "application/vnd.groove-identity-message");
    m.put("grv", "application/vnd.groove-injector");
    m.put("gtm", "application/vnd.groove-tool-message");
    m.put("tpl", "application/vnd.groove-tool-template");
    m.put("vcg", "application/vnd.groove-vcard");
    m.put("hal", "application/vnd.hal+xml");
    m.put("zmm", "application/vnd.handheld-entertainment+xml");
    m.put("hbci", "application/vnd.hbci");
    m.put("les", "application/vnd.hhe.lesson-player");
    m.put("hpgl", "application/vnd.hp-hpgl");
    m.put("hpid", "application/vnd.hp-hpid");
    m.put("hps", "application/vnd.hp-hps");
    m.put("jlt", "application/vnd.hp-jlyt");
    m.put("pcl", "application/vnd.hp-pcl");
    m.put("pclxl", "application/vnd.hp-pclxl");
    m.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
    m.put("mpy", "application/vnd.ibm.minipay");
    m.put("afp", "application/vnd.ibm.modcap");
    m.put("listafp", "application/vnd.ibm.modcap");
    m.put("list3820", "application/vnd.ibm.modcap");
    m.put("irm", "application/vnd.ibm.rights-management");
    m.put("sc", "application/vnd.ibm.secure-container");
    m.put("icc", "application/vnd.iccprofile");
    m.put("icm", "application/vnd.iccprofile");
    m.put("igl", "application/vnd.igloader");
    m.put("ivp", "application/vnd.immervision-ivp");
    m.put("ivu", "application/vnd.immervision-ivu");
    m.put("igm", "application/vnd.insors.igm");
    m.put("xpw", "application/vnd.intercon.formnet");
    m.put("xpx", "application/vnd.intercon.formnet");
    m.put("i2g", "application/vnd.intergeo");
    m.put("qbo", "application/vnd.intu.qbo");
    m.put("qfx", "application/vnd.intu.qfx");
    m.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
    m.put("irp", "application/vnd.irepository.package+xml");
    m.put("xpr", "application/vnd.is-xpr");
    m.put("fcs", "application/vnd.isac.fcs");
    m.put("jam", "application/vnd.jam");
    m.put("rms", "application/vnd.jcp.javame.midlet-rms");
    m.put("jisp", "application/vnd.jisp");
    m.put("joda", "application/vnd.joost.joda-archive");
    m.put("ktz", "application/vnd.kahootz");
    m.put("ktr", "application/vnd.kahootz");
    m.put("karbon", "application/vnd.kde.karbon");
    m.put("chrt", "application/vnd.kde.kchart");
    m.put("kfo", "application/vnd.kde.kformula");
    m.put("flw", "application/vnd.kde.kivio");
    m.put("kon", "application/vnd.kde.kontour");
    m.put("kpr", "application/vnd.kde.kpresenter");
    m.put("kpt", "application/vnd.kde.kpresenter");
    m.put("ksp", "application/vnd.kde.kspread");
    m.put("kwd", "application/vnd.kde.kword");
    m.put("kwt", "application/vnd.kde.kword");
    m.put("htke", "application/vnd.kenameaapp");
    m.put("kia", "application/vnd.kidspiration");
    m.put("kne", "application/vnd.kinar");
    m.put("knp", "application/vnd.kinar");
    m.put("skp", "application/vnd.koan");
    m.put("skd", "application/vnd.koan");
    m.put("skt", "application/vnd.koan");
    m.put("skm", "application/vnd.koan");
    m.put("sse", "application/vnd.kodak-descriptor");
    m.put("lasxml", "application/vnd.las.las+xml");
    m.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
    m.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
    m.put("123", "application/vnd.lotus-1-2-3");
    m.put("apr", "application/vnd.lotus-approach");
    m.put("pre", "application/vnd.lotus-freelance");
    m.put("nsf", "application/vnd.lotus-notes");
    m.put("org", "application/vnd.lotus-organizer");
    m.put("scm", "application/vnd.lotus-screencam");
    m.put("lwp", "application/vnd.lotus-wordpro");
    m.put("portpkg", "application/vnd.macports.portpkg");
    m.put("mcd", "application/vnd.mcd");
    m.put("mc1", "application/vnd.medcalcdata");
    m.put("cdkey", "application/vnd.mediastation.cdkey");
    m.put("mwf", "application/vnd.mfer");
    m.put("mfm", "application/vnd.mfmp");
    m.put("flo", "application/vnd.micrografx.flo");
    m.put("igx", "application/vnd.micrografx.igx");
    m.put("mif", "application/vnd.mif");
    m.put("daf", "application/vnd.mobius.daf");
    m.put("dis", "application/vnd.mobius.dis");
    m.put("mbk", "application/vnd.mobius.mbk");
    m.put("mqy", "application/vnd.mobius.mqy");
    m.put("msl", "application/vnd.mobius.msl");
    m.put("plc", "application/vnd.mobius.plc");
    m.put("txf", "application/vnd.mobius.txf");
    m.put("mpn", "application/vnd.mophun.application");
    m.put("mpc", "application/vnd.mophun.certificate");
    m.put("xul", "application/vnd.mozilla.xul+xml");
    m.put("cil", "application/vnd.ms-artgalry");
    m.put("cab", "application/vnd.ms-cab-compressed");
    m.put("xls", "application/vnd.ms-excel");
    m.put("xlm", "application/vnd.ms-excel");
    m.put("xla", "application/vnd.ms-excel");
    m.put("xlc", "application/vnd.ms-excel");
    m.put("xlt", "application/vnd.ms-excel");
    m.put("xlw", "application/vnd.ms-excel");
    m.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
    m.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
    m.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
    m.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
    m.put("eot", "application/vnd.ms-fontobject");
    m.put("chm", "application/vnd.ms-htmlhelp");
    m.put("ims", "application/vnd.ms-ims");
    m.put("lrm", "application/vnd.ms-lrm");
    m.put("thmx", "application/vnd.ms-officetheme");
    m.put("cat", "application/vnd.ms-pki.seccat");
    m.put("stl", "application/vnd.ms-pki.stl");
    m.put("ppt", "application/vnd.ms-powerpoint");
    m.put("pps", "application/vnd.ms-powerpoint");
    m.put("pot", "application/vnd.ms-powerpoint");
    m.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
    m.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
    m.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
    m.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
    m.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
    m.put("mpp", "application/vnd.ms-project");
    m.put("mpt", "application/vnd.ms-project");
    m.put("docm", "application/vnd.ms-word.document.macroenabled.12");
    m.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
    m.put("wps", "application/vnd.ms-works");
    m.put("wks", "application/vnd.ms-works");
    m.put("wcm", "application/vnd.ms-works");
    m.put("wdb", "application/vnd.ms-works");
    m.put("wpl", "application/vnd.ms-wpl");
    m.put("xps", "application/vnd.ms-xpsdocument");
    m.put("mseq", "application/vnd.mseq");
    m.put("mus", "application/vnd.musician");
    m.put("msty", "application/vnd.muvee.style");
    m.put("taglet", "application/vnd.mynfc");
    m.put("nlu", "application/vnd.neurolanguage.nlu");
    m.put("ntf", "application/vnd.nitf");
    m.put("nitf", "application/vnd.nitf");
    m.put("nnd", "application/vnd.noblenet-directory");
    m.put("nns", "application/vnd.noblenet-sealer");
    m.put("nnw", "application/vnd.noblenet-web");
    m.put("ngdat", "application/vnd.nokia.n-gage.data");
    m.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
    m.put("rpst", "application/vnd.nokia.radio-preset");
    m.put("rpss", "application/vnd.nokia.radio-presets");
    m.put("edm", "application/vnd.novadigm.edm");
    m.put("edx", "application/vnd.novadigm.edx");
    m.put("ext", "application/vnd.novadigm.ext");
    m.put("odc", "application/vnd.oasis.opendocument.chart");
    m.put("otc", "application/vnd.oasis.opendocument.chart-template");
    m.put("odb", "application/vnd.oasis.opendocument.database");
    m.put("odf", "application/vnd.oasis.opendocument.formula");
    m.put("odft", "application/vnd.oasis.opendocument.formula-template");
    m.put("odg", "application/vnd.oasis.opendocument.graphics");
    m.put("otg", "application/vnd.oasis.opendocument.graphics-template");
    m.put("odi", "application/vnd.oasis.opendocument.image");
    m.put("oti", "application/vnd.oasis.opendocument.image-template");
    m.put("odp", "application/vnd.oasis.opendocument.presentation");
    m.put("otp", "application/vnd.oasis.opendocument.presentation-template");
    m.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
    m.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
    m.put("odt", "application/vnd.oasis.opendocument.text");
    m.put("odm", "application/vnd.oasis.opendocument.text-master");
    m.put("ott", "application/vnd.oasis.opendocument.text-template");
    m.put("oth", "application/vnd.oasis.opendocument.text-web");
    m.put("xo", "application/vnd.olpc-sugar");
    m.put("dd2", "application/vnd.oma.dd2+xml");
    m.put("oxt", "application/vnd.openofficeorg.extension");
    m.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    m.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
    m.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
    m.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
    m.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    m.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
    m.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    m.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
    m.put("mgp", "application/vnd.osgeo.mapguide.package");
    m.put("dp", "application/vnd.osgi.dp");
    m.put("esa", "application/vnd.osgi.subsystem");
    m.put("pdb", "application/vnd.palm");
    m.put("pqa", "application/vnd.palm");
    m.put("oprc", "application/vnd.palm");
    m.put("paw", "application/vnd.pawaafile");
    m.put("str", "application/vnd.pg.format");
    m.put("ei6", "application/vnd.pg.osasli");
    m.put("efif", "application/vnd.picsel");
    m.put("wg", "application/vnd.pmi.widget");
    m.put("plf", "application/vnd.pocketlearn");
    m.put("pbd", "application/vnd.powerbuilder6");
    m.put("box", "application/vnd.previewsystems.box");
    m.put("mgz", "application/vnd.proteus.magazine");
    m.put("qps", "application/vnd.publishare-delta-tree");
    m.put("ptid", "application/vnd.pvi.ptid1");
    m.put("qxd", "application/vnd.quark.quarkxpress");
    m.put("qxt", "application/vnd.quark.quarkxpress");
    m.put("qwd", "application/vnd.quark.quarkxpress");
    m.put("qwt", "application/vnd.quark.quarkxpress");
    m.put("qxl", "application/vnd.quark.quarkxpress");
    m.put("qxb", "application/vnd.quark.quarkxpress");
    m.put("bed", "application/vnd.realvnc.bed");
    m.put("mxl", "application/vnd.recordare.musicxml");
    m.put("musicxml", "application/vnd.recordare.musicxml+xml");
    m.put("cryptonote", "application/vnd.rig.cryptonote");
    m.put("cod", "application/vnd.rim.cod");
    m.put("rm", "application/vnd.rn-realmedia");
    m.put("rmvb", "application/vnd.rn-realmedia-vbr");
    m.put("link66", "application/vnd.route66.link66+xml");
    m.put("st", "application/vnd.sailingtracker.track");
    m.put("see", "application/vnd.seemail");
    m.put("sema", "application/vnd.sema");
    m.put("semd", "application/vnd.semd");
    m.put("semf", "application/vnd.semf");
    m.put("ifm", "application/vnd.shana.informed.formdata");
    m.put("itp", "application/vnd.shana.informed.formtemplate");
    m.put("iif", "application/vnd.shana.informed.interchange");
    m.put("ipk", "application/vnd.shana.informed.package");
    m.put("twd", "application/vnd.simtech-mindmapper");
    m.put("twds", "application/vnd.simtech-mindmapper");
    m.put("mmf", "application/vnd.smaf");
    m.put("teacher", "application/vnd.smart.teacher");
    m.put("sdkm", "application/vnd.solent.sdkm+xml");
    m.put("sdkd", "application/vnd.solent.sdkm+xml");
    m.put("dxp", "application/vnd.spotfire.dxp");
    m.put("sfs", "application/vnd.spotfire.sfs");
    m.put("sdc", "application/vnd.stardivision.calc");
    m.put("sda", "application/vnd.stardivision.draw");
    m.put("sdd", "application/vnd.stardivision.impress");
    m.put("smf", "application/vnd.stardivision.math");
    m.put("sdw", "application/vnd.stardivision.writer");
    m.put("vor", "application/vnd.stardivision.writer");
    m.put("sgl", "application/vnd.stardivision.writer-global");
    m.put("smzip", "application/vnd.stepmania.package");
    m.put("sm", "application/vnd.stepmania.stepchart");
    m.put("sxc", "application/vnd.sun.xml.calc");
    m.put("stc", "application/vnd.sun.xml.calc.template");
    m.put("sxd", "application/vnd.sun.xml.draw");
    m.put("std", "application/vnd.sun.xml.draw.template");
    m.put("sxi", "application/vnd.sun.xml.impress");
    m.put("sti", "application/vnd.sun.xml.impress.template");
    m.put("sxm", "application/vnd.sun.xml.math");
    m.put("sxw", "application/vnd.sun.xml.writer");
    m.put("sxg", "application/vnd.sun.xml.writer.global");
    m.put("stw", "application/vnd.sun.xml.writer.template");
    m.put("sus", "application/vnd.sus-calendar");
    m.put("susp", "application/vnd.sus-calendar");
    m.put("svd", "application/vnd.svd");
    m.put("sis", "application/vnd.symbian.install");
    m.put("sisx", "application/vnd.symbian.install");
    m.put("xsm", "application/vnd.syncml+xml");
    m.put("bdm", "application/vnd.syncml.dm+wbxml");
    m.put("xdm", "application/vnd.syncml.dm+xml");
    m.put("tao", "application/vnd.tao.intent-module-archive");
    m.put("pcap", "application/vnd.tcpdump.pcap");
    m.put("cap", "application/vnd.tcpdump.pcap");
    m.put("dmp", "application/vnd.tcpdump.pcap");
    m.put("tmo", "application/vnd.tmobile-livetv");
    m.put("tpt", "application/vnd.trid.tpt");
    m.put("mxs", "application/vnd.triscape.mxs");
    m.put("tra", "application/vnd.trueapp");
    m.put("ufd", "application/vnd.ufdl");
    m.put("ufdl", "application/vnd.ufdl");
    m.put("utz", "application/vnd.uiq.theme");
    m.put("umj", "application/vnd.umajin");
    m.put("unityweb", "application/vnd.unity");
    m.put("uoml", "application/vnd.uoml+xml");
    m.put("vcx", "application/vnd.vcx");
    m.put("vsd", "application/vnd.visio");
    m.put("vst", "application/vnd.visio");
    m.put("vss", "application/vnd.visio");
    m.put("vsw", "application/vnd.visio");
    m.put("vis", "application/vnd.visionary");
    m.put("vsf", "application/vnd.vsf");
    m.put("wbxml", "application/vnd.wap.wbxml");
    m.put("wmlc", "application/vnd.wap.wmlc");
    m.put("wmlsc", "application/vnd.wap.wmlscriptc");
    m.put("wtb", "application/vnd.webturbo");
    m.put("nbp", "application/vnd.wolfram.player");
    m.put("wpd", "application/vnd.wordperfect");
    m.put("wqd", "application/vnd.wqd");
    m.put("stf", "application/vnd.wt.stf");
    m.put("xar", "application/vnd.xara");
    m.put("xfdl", "application/vnd.xfdl");
    m.put("hvd", "application/vnd.yamaha.hv-dic");
    m.put("hvs", "application/vnd.yamaha.hv-script");
    m.put("hvp", "application/vnd.yamaha.hv-voice");
    m.put("osf", "application/vnd.yamaha.openscoreformat");
    m.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
    m.put("saf", "application/vnd.yamaha.smaf-audio");
    m.put("spf", "application/vnd.yamaha.smaf-phrase");
    m.put("cmp", "application/vnd.yellowriver-custom-menu");
    m.put("zir", "application/vnd.zul");
    m.put("zirz", "application/vnd.zul");
    m.put("zaz", "application/vnd.zzazz.deck+xml");
    m.put("vxml", "application/voicexml+xml");
    m.put("wasm", "application/wasm");
    m.put("wgt", "application/widget");
    m.put("hlp", "application/winhlp");
    m.put("wsdl", "application/wsdl+xml");
    m.put("wspolicy", "application/wspolicy+xml");
    m.put("7z", "application/x-7z-compressed");
    m.put("abw", "application/x-abiword");
    m.put("ace", "application/x-ace-compressed");
    m.put("dmg", "application/x-apple-diskimage");
    m.put("aab", "application/x-authorware-bin");
    m.put("x32", "application/x-authorware-bin");
    m.put("u32", "application/x-authorware-bin");
    m.put("vox", "application/x-authorware-bin");
    m.put("aam", "application/x-authorware-map");
    m.put("aas", "application/x-authorware-seg");
    m.put("bcpio", "application/x-bcpio");
    m.put("torrent", "application/x-bittorrent");
    m.put("blb", "application/x-blorb");
    m.put("blorb", "application/x-blorb");
    m.put("bz", "application/x-bzip");
    m.put("bz2", "application/x-bzip2");
    m.put("boz", "application/x-bzip2");
    m.put("cbr", "application/x-cbr");
    m.put("cba", "application/x-cbr");
    m.put("cbt", "application/x-cbr");
    m.put("cbz", "application/x-cbr");
    m.put("cb7", "application/x-cbr");
    m.put("vcd", "application/x-cdlink");
    m.put("cfs", "application/x-cfs-compressed");
    m.put("chat", "application/x-chat");
    m.put("pgn", "application/x-chess-pgn");
    m.put("nsc", "application/x-conference");
    m.put("cpio", "application/x-cpio");
    m.put("csh", "application/x-csh");
    m.put("deb", "application/x-debian-package");
    m.put("udeb", "application/x-debian-package");
    m.put("dgc", "application/x-dgc-compressed");
    m.put("dir", "application/x-director");
    m.put("dcr", "application/x-director");
    m.put("dxr", "application/x-director");
    m.put("cst", "application/x-director");
    m.put("cct", "application/x-director");
    m.put("cxt", "application/x-director");
    m.put("w3d", "application/x-director");
    m.put("fgd", "application/x-director");
    m.put("swa", "application/x-director");
    m.put("wad", "application/x-doom");
    m.put("ncx", "application/x-dtbncx+xml");
    m.put("dtb", "application/x-dtbook+xml");
    m.put("res", "application/x-dtbresource+xml");
    m.put("dvi", "application/x-dvi");
    m.put("evy", "application/x-envoy");
    m.put("eva", "application/x-eva");
    m.put("bdf", "application/x-font-bdf");
    m.put("gsf", "application/x-font-ghostscript");
    m.put("psf", "application/x-font-linux-psf");
    m.put("otf", "application/x-font-otf");
    m.put("pcf", "application/x-font-pcf");
    m.put("snf", "application/x-font-snf");
    m.put("ttf", "application/x-font-ttf");
    m.put("ttc", "application/x-font-ttf");
    m.put("pfa", "application/x-font-type1");
    m.put("pfb", "application/x-font-type1");
    m.put("pfm", "application/x-font-type1");
    m.put("afm", "application/x-font-type1");
    m.put("woff", "application/x-font-woff");
    m.put("woff2", "font/woff2");
    m.put("arc", "application/x-freearc");
    m.put("spl", "application/x-futuresplash");
    m.put("gca", "application/x-gca-compressed");
    m.put("ulx", "application/x-glulx");
    m.put("gnumeric", "application/x-gnumeric");
    m.put("gramps", "application/x-gramps-xml");
    m.put("gtar", "application/x-gtar");
    m.put("hdf", "application/x-hdf");
    m.put("install", "application/x-install-instructions");
    m.put("iso", "application/x-iso9660-image");
    m.put("jnlp", "application/x-java-jnlp-file");
    m.put("latex", "application/x-latex");
    m.put("lzh", "application/x-lzh-compressed");
    m.put("lha", "application/x-lzh-compressed");
    m.put("mie", "application/x-mie");
    m.put("prc", "application/x-mobipocket-ebook");
    m.put("mobi", "application/x-mobipocket-ebook");
    m.put("application", "application/x-ms-application");
    m.put("lnk", "application/x-ms-shortcut");
    m.put("wmd", "application/x-ms-wmd");
    m.put("wmz", "application/x-ms-wmz");
    m.put("xbap", "application/x-ms-xbap");
    m.put("mdb", "application/x-msaccess");
    m.put("obd", "application/x-msbinder");
    m.put("crd", "application/x-mscardfile");
    m.put("clp", "application/x-msclip");
    m.put("exe", "application/x-msdownload");
    m.put("dll", "application/x-msdownload");
    m.put("com", "application/x-msdownload");
    m.put("bat", "application/x-msdownload");
    m.put("msi", "application/x-msdownload");
    m.put("mvb", "application/x-msmediaview");
    m.put("m13", "application/x-msmediaview");
    m.put("m14", "application/x-msmediaview");
    m.put("wmf", "application/x-msmetafile");
    m.put("emf", "application/x-msmetafile");
    m.put("emz", "application/x-msmetafile");
    m.put("mny", "application/x-msmoney");
    m.put("pub", "application/x-mspublisher");
    m.put("scd", "application/x-msschedule");
    m.put("trm", "application/x-msterminal");
    m.put("wri", "application/x-mswrite");
    m.put("nc", "application/x-netcdf");
    m.put("cdf", "application/x-netcdf");
    m.put("nzb", "application/x-nzb");
    m.put("p12", "application/x-pkcs12");
    m.put("pfx", "application/x-pkcs12");
    m.put("p7b", "application/x-pkcs7-certificates");
    m.put("spc", "application/x-pkcs7-certificates");
    m.put("p7r", "application/x-pkcs7-certreqresp");
    m.put("rar", "application/x-rar-compressed");
    m.put("ris", "application/x-research-info-systems");
    m.put("sh", "application/x-sh");
    m.put("shar", "application/x-shar");
    m.put("swf", "application/x-shockwave-flash");
    m.put("xap", "application/x-silverlight-app");
    m.put("sql", "application/x-sql");
    m.put("sit", "application/x-stuffit");
    m.put("sitx", "application/x-stuffitx");
    m.put("srt", "application/x-subrip");
    m.put("sv4cpio", "application/x-sv4cpio");
    m.put("sv4crc", "application/x-sv4crc");
    m.put("t3", "application/x-t3vm-image");
    m.put("gam", "application/x-tads");
    m.put("tar", "application/x-tar");
    m.put("tcl", "application/x-tcl");
    m.put("tex", "application/x-tex");
    m.put("tfm", "application/x-tex-tfm");
    m.put("texinfo", "application/x-texinfo");
    m.put("texi", "application/x-texinfo");
    m.put("obj", "application/x-tgif");
    m.put("ustar", "application/x-ustar");
    m.put("src", "application/x-wais-source");
    m.put("der", "application/x-x509-ca-cert");
    m.put("crt", "application/x-x509-ca-cert");
    m.put("fig", "application/x-xfig");
    m.put("xlf", "application/x-xliff+xml");
    m.put("xpi", "application/x-xpinstall");
    m.put("xz", "application/x-xz");
    m.put("yml", "application/x-yaml");
    m.put("yaml", "application/x-yaml");
    m.put("z1", "application/x-zmachine");
    m.put("z2", "application/x-zmachine");
    m.put("z3", "application/x-zmachine");
    m.put("z4", "application/x-zmachine");
    m.put("z5", "application/x-zmachine");
    m.put("z6", "application/x-zmachine");
    m.put("z7", "application/x-zmachine");
    m.put("z8", "application/x-zmachine");
    m.put("xaml", "application/xaml+xml");
    m.put("xdf", "application/xcap-diff+xml");
    m.put("xenc", "application/xenc+xml");
    m.put("xhtml", "application/xhtml+xml");
    m.put("xht", "application/xhtml+xml");
    m.put("xml", "application/xml");
    m.put("xsl", "application/xml");
    m.put("dtd", "application/xml-dtd");
    m.put("xop", "application/xop+xml");
    m.put("xpl", "application/xproc+xml");
    m.put("xslt", "application/xslt+xml");
    m.put("xspf", "application/xspf+xml");
    m.put("mxml", "application/xv+xml");
    m.put("xhvml", "application/xv+xml");
    m.put("xvml", "application/xv+xml");
    m.put("xvm", "application/xv+xml");
    m.put("yang", "application/yang");
    m.put("yin", "application/yin+xml");
    m.put("zip", "application/zip");
    m.put("adp", "audio/adpcm");
    m.put("au", "audio/basic");
    m.put("snd", "audio/basic");
    m.put("mid", "audio/midi");
    m.put("midi", "audio/midi");
    m.put("kar", "audio/midi");
    m.put("rmi", "audio/midi");
    m.put("mp4a", "audio/mp4");
    m.put("mpga", "audio/mpeg");
    m.put("mp2", "audio/mpeg");
    m.put("mp2a", "audio/mpeg");
    m.put("mp3", "audio/mpeg");
    m.put("m2a", "audio/mpeg");
    m.put("m3a", "audio/mpeg");
    m.put("oga", "audio/ogg");
    m.put("ogg", "audio/ogg");
    m.put("spx", "audio/ogg");
    m.put("s3m", "audio/s3m");
    m.put("sil", "audio/silk");
    m.put("uva", "audio/vnd.dece.audio");
    m.put("uvva", "audio/vnd.dece.audio");
    m.put("eol", "audio/vnd.digital-winds");
    m.put("dra", "audio/vnd.dra");
    m.put("dts", "audio/vnd.dts");
    m.put("dtshd", "audio/vnd.dts.hd");
    m.put("lvp", "audio/vnd.lucent.voice");
    m.put("pya", "audio/vnd.ms-playready.media.pya");
    m.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
    m.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
    m.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
    m.put("rip", "audio/vnd.rip");
    m.put("weba", "audio/webm");
    m.put("aac", "audio/x-aac");
    m.put("aif", "audio/x-aiff");
    m.put("aiff", "audio/x-aiff");
    m.put("aifc", "audio/x-aiff");
    m.put("caf", "audio/x-caf");
    m.put("flac", "audio/x-flac");
    m.put("mka", "audio/x-matroska");
    m.put("m3u", "audio/x-mpegurl");
    m.put("wax", "audio/x-ms-wax");
    m.put("wma", "audio/x-ms-wma");
    m.put("ram", "audio/x-pn-realaudio");
    m.put("ra", "audio/x-pn-realaudio");
    m.put("rmp", "audio/x-pn-realaudio-plugin");
    m.put("wav", "audio/x-wav");
    m.put("xm", "audio/xm");
    m.put("cdx", "chemical/x-cdx");
    m.put("cif", "chemical/x-cif");
    m.put("cmdf", "chemical/x-cmdf");
    m.put("cml", "chemical/x-cml");
    m.put("csml", "chemical/x-csml");
    m.put("xyz", "chemical/x-xyz");
    m.put("bmp", "image/bmp");
    m.put("cgm", "image/cgm");
    m.put("g3", "image/g3fax");
    m.put("gif", "image/gif");
    m.put("ief", "image/ief");
    m.put("jpeg", "image/jpeg");
    m.put("jpg", "image/jpeg");
    m.put("jpe", "image/jpeg");
    m.put("ktx", "image/ktx");
    m.put("png", "image/png");
    m.put("btif", "image/prs.btif");
    m.put("sgi", "image/sgi");
    m.put("svg", "image/svg+xml");
    m.put("svgz", "image/svg+xml");
    m.put("tiff", "image/tiff");
    m.put("tif", "image/tiff");
    m.put("psd", "image/vnd.adobe.photoshop");
    m.put("uvi", "image/vnd.dece.graphic");
    m.put("uvvi", "image/vnd.dece.graphic");
    m.put("uvg", "image/vnd.dece.graphic");
    m.put("uvvg", "image/vnd.dece.graphic");
    m.put("sub", "image/vnd.dvb.subtitle");
    m.put("djvu", "image/vnd.djvu");
    m.put("djv", "image/vnd.djvu");
    m.put("dwg", "image/vnd.dwg");
    m.put("dxf", "image/vnd.dxf");
    m.put("fbs", "image/vnd.fastbidsheet");
    m.put("fpx", "image/vnd.fpx");
    m.put("fst", "image/vnd.fst");
    m.put("mmr", "image/vnd.fujixerox.edmics-mmr");
    m.put("rlc", "image/vnd.fujixerox.edmics-rlc");
    m.put("mdi", "image/vnd.ms-modi");
    m.put("wdp", "image/vnd.ms-photo");
    m.put("npx", "image/vnd.net-fpx");
    m.put("wbmp", "image/vnd.wap.wbmp");
    m.put("xif", "image/vnd.xiff");
    m.put("webp", "image/webp");
    m.put("3ds", "image/x-3ds");
    m.put("ras", "image/x-cmu-raster");
    m.put("cmx", "image/x-cmx");
    m.put("fh", "image/x-freehand");
    m.put("fhc", "image/x-freehand");
    m.put("fh4", "image/x-freehand");
    m.put("fh5", "image/x-freehand");
    m.put("fh7", "image/x-freehand");
    m.put("ico", "image/x-icon");
    m.put("sid", "image/x-mrsid-image");
    m.put("pcx", "image/x-pcx");
    m.put("pic", "image/x-pict");
    m.put("pct", "image/x-pict");
    m.put("pnm", "image/x-portable-anymap");
    m.put("pbm", "image/x-portable-bitmap");
    m.put("pgm", "image/x-portable-graymap");
    m.put("ppm", "image/x-portable-pixmap");
    m.put("rgb", "image/x-rgb");
    m.put("tga", "image/x-tga");
    m.put("xbm", "image/x-xbitmap");
    m.put("xpm", "image/x-xpixmap");
    m.put("xwd", "image/x-xwindowdump");
    m.put("eml", "message/rfc822");
    m.put("mime", "message/rfc822");
    m.put("igs", "model/iges");
    m.put("iges", "model/iges");
    m.put("msh", "model/mesh");
    m.put("mesh", "model/mesh");
    m.put("silo", "model/mesh");
    m.put("dae", "model/vnd.collada+xml");
    m.put("dwf", "model/vnd.dwf");
    m.put("gdl", "model/vnd.gdl");
    m.put("gtw", "model/vnd.gtw");
    m.put("mts", "model/vnd.mts");
    m.put("vtu", "model/vnd.vtu");
    m.put("wrl", "model/vrml");
    m.put("vrml", "model/vrml");
    m.put("x3db", "model/x3d+binary");
    m.put("x3dbz", "model/x3d+binary");
    m.put("x3dv", "model/x3d+vrml");
    m.put("x3dvz", "model/x3d+vrml");
    m.put("x3d", "model/x3d+xml");
    m.put("x3dz", "model/x3d+xml");
    m.put("appcache", "text/cache-manifest");
    m.put("ics", "text/calendar");
    m.put("ifb", "text/calendar");
    m.put("css", "text/css");
    m.put("csv", "text/csv");
    m.put("html", "text/html");
    m.put("htm", "text/html");
    m.put("n3", "text/n3");
    m.put("txt", "text/plain");
    m.put("text", "text/plain");
    m.put("conf", "text/plain");
    m.put("def", "text/plain");
    m.put("list", "text/plain");
    m.put("log", "text/plain");
    m.put("in", "text/plain");
    m.put("dsc", "text/prs.lines.tag");
    m.put("rtx", "text/richtext");
    m.put("sgml", "text/sgml");
    m.put("sgm", "text/sgml");
    m.put("tsv", "text/tab-separated-values");
    m.put("t", "text/troff");
    m.put("tr", "text/troff");
    m.put("roff", "text/troff");
    m.put("man", "text/troff");
    m.put("me", "text/troff");
    m.put("ms", "text/troff");
    m.put("ttl", "text/turtle");
    m.put("uri", "text/uri-list");
    m.put("uris", "text/uri-list");
    m.put("urls", "text/uri-list");
    m.put("vcard", "text/vcard");
    m.put("curl", "text/vnd.curl");
    m.put("dcurl", "text/vnd.curl.dcurl");
    m.put("scurl", "text/vnd.curl.scurl");
    m.put("mcurl", "text/vnd.curl.mcurl");
    m.put("fly", "text/vnd.fly");
    m.put("flx", "text/vnd.fmi.flexstor");
    m.put("gv", "text/vnd.graphviz");
    m.put("3dml", "text/vnd.in3d.3dml");
    m.put("spot", "text/vnd.in3d.spot");
    m.put("jad", "text/vnd.sun.j2me.app-descriptor");
    m.put("wml", "text/vnd.wap.wml");
    m.put("wmls", "text/vnd.wap.wmlscript");
    m.put("s", "text/x-asm");
    m.put("asm", "text/x-asm");
    m.put("c", "text/x-c");
    m.put("cc", "text/x-c");
    m.put("cxx", "text/x-c");
    m.put("cpp", "text/x-c");
    m.put("h", "text/x-c");
    m.put("hh", "text/x-c");
    m.put("dic", "text/x-c");
    m.put("f", "text/x-fortran");
    m.put("for", "text/x-fortran");
    m.put("f77", "text/x-fortran");
    m.put("f90", "text/x-fortran");
    m.put("java", "text/x-java-source");
    m.put("opml", "text/x-opml");
    m.put("p", "text/x-pascal");
    m.put("pas", "text/x-pascal");
    m.put("nfo", "text/x-nfo");
    m.put("etx", "text/x-setext");
    m.put("sfv", "text/x-sfv");
    m.put("uu", "text/x-uuencode");
    m.put("vcs", "text/x-vcalendar");
    m.put("vcf", "text/x-vcard");
    m.put("3gp", "video/3gpp");
    m.put("3g2", "video/3gpp2");
    m.put("h261", "video/h261");
    m.put("h263", "video/h263");
    m.put("h264", "video/h264");
    m.put("jpgv", "video/jpeg");
    m.put("jpm", "video/jpm");
    m.put("jpgm", "video/jpm");
    m.put("mj2", "video/mj2");
    m.put("mjp2", "video/mj2");
    m.put("mp4", "video/mp4");
    m.put("mp4v", "video/mp4");
    m.put("mpg4", "video/mp4");
    m.put("mpeg", "video/mpeg");
    m.put("mpg", "video/mpeg");
    m.put("mpe", "video/mpeg");
    m.put("m1v", "video/mpeg");
    m.put("m2v", "video/mpeg");
    m.put("ogv", "video/ogg");
    m.put("qt", "video/quicktime");
    m.put("mov", "video/quicktime");
    m.put("uvh", "video/vnd.dece.hd");
    m.put("uvvh", "video/vnd.dece.hd");
    m.put("uvm", "video/vnd.dece.mobile");
    m.put("uvvm", "video/vnd.dece.mobile");
    m.put("uvp", "video/vnd.dece.pd");
    m.put("uvvp", "video/vnd.dece.pd");
    m.put("uvs", "video/vnd.dece.sd");
    m.put("uvvs", "video/vnd.dece.sd");
    m.put("uvv", "video/vnd.dece.video");
    m.put("uvvv", "video/vnd.dece.video");
    m.put("dvb", "video/vnd.dvb.file");
    m.put("fvt", "video/vnd.fvt");
    m.put("mxu", "video/vnd.mpegurl");
    m.put("m4u", "video/vnd.mpegurl");
    m.put("pyv", "video/vnd.ms-playready.media.pyv");
    m.put("uvu", "video/vnd.uvvu.mp4");
    m.put("uvvu", "video/vnd.uvvu.mp4");
    m.put("viv", "video/vnd.vivo");
    m.put("webm", "video/webm");
    m.put("f4v", "video/x-f4v");
    m.put("fli", "video/x-fli");
    m.put("flv", "video/x-flv");
    m.put("m4v", "video/x-m4v");
    m.put("mkv", "video/x-matroska");
    m.put("mk3d", "video/x-matroska");
    m.put("mks", "video/x-matroska");
    m.put("mng", "video/x-mng");
    m.put("asf", "video/x-ms-asf");
    m.put("asx", "video/x-ms-asf");
    m.put("vob", "video/x-ms-vob");
    m.put("wm", "video/x-ms-wm");
    m.put("wmv", "video/x-ms-wmv");
    m.put("wmx", "video/x-ms-wmx");
    m.put("wvx", "video/x-ms-wvx");
    m.put("avi", "video/x-msvideo");
    m.put("movie", "video/x-sgi-movie");
    m.put("smv", "video/x-smv");
    m.put("ice", "x-conference/x-cooltalk");
  }

  public static String getMimeTypeForExtension(String ext) {
    return m.get(ext);
  }
  public static String getMimeTypeForFilename(String filename) {
    int li = filename.lastIndexOf('.');
    if (li != -1 && li != filename.length() - 1) {
      String ext = filename.substring(li + 1, filename.length());
      return MimeMapping.getMimeTypeForExtension(ext);
    }
    return null;
  }
}
