/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientResponseImpl;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.impl.GrpcMessageImpl;
import java.util.Map;
import java.util.Objects;

public class GrpcClientRequestImpl<Req, Resp>
implements GrpcClientRequest<Req, Resp> {
    private final HttpClientRequest httpRequest;
    private final GrpcMessageEncoder<Req> messageEncoder;
    private ServiceName serviceName;
    private String methodName;
    private String encoding = null;
    private boolean headersSent;
    private boolean cancelled;
    boolean trailersSent;
    private Future<GrpcClientResponse<Req, Resp>> response;
    private MultiMap headers;

    public GrpcClientRequestImpl(HttpClientRequest httpRequest, GrpcMessageEncoder<Req> messageEncoder, GrpcMessageDecoder<Resp> messageDecoder) {
        this.httpRequest = httpRequest;
        this.messageEncoder = messageEncoder;
        this.response = httpRequest.response().map(httpResponse -> {
            GrpcClientResponseImpl grpcResponse = new GrpcClientResponseImpl(this, (HttpClientResponse)httpResponse, messageDecoder);
            grpcResponse.init();
            return grpcResponse;
        });
    }

    public MultiMap headers() {
        if (this.headersSent) {
            throw new IllegalStateException("Headers already sent");
        }
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.headers;
    }

    @Override
    public GrpcClientRequest<Req, Resp> serviceName(ServiceName serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> fullMethodName(String fullMethodName) {
        if (this.headersSent) {
            throw new IllegalStateException("Request already sent");
        }
        int idx = fullMethodName.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        this.serviceName = ServiceName.create((String)fullMethodName.substring(0, idx));
        this.methodName = fullMethodName.substring(idx + 1);
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> encoding(String encoding) {
        Objects.requireNonNull(encoding);
        this.encoding = encoding;
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> exceptionHandler(Handler<Throwable> handler) {
        this.httpRequest.exceptionHandler(handler);
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> setWriteQueueMaxSize(int maxSize) {
        this.httpRequest.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.httpRequest.writeQueueFull();
    }

    @Override
    public GrpcClientRequest<Req, Resp> drainHandler(Handler<Void> handler) {
        this.httpRequest.drainHandler(handler);
        return this;
    }

    public Future<Void> writeMessage(GrpcMessage message) {
        return this.writeMessage(message, false);
    }

    public Future<Void> endMessage(GrpcMessage message) {
        return this.writeMessage(message, true);
    }

    public Future<Void> end() {
        if (this.cancelled) {
            throw new IllegalStateException("The stream has been cancelled");
        }
        if (!this.headersSent) {
            throw new IllegalStateException("You must send a message before terminating the stream");
        }
        if (this.trailersSent) {
            throw new IllegalStateException("The stream has been closed");
        }
        this.trailersSent = true;
        return this.httpRequest.end();
    }

    private Future<Void> writeMessage(GrpcMessage message, boolean end) {
        if (this.cancelled) {
            throw new IllegalStateException("The stream has been cancelled");
        }
        if (this.trailersSent) {
            throw new IllegalStateException("The stream has been closed");
        }
        if (this.encoding != null && !this.encoding.equals(message.encoding())) {
            switch (this.encoding) {
                case "gzip": {
                    message = GrpcMessageEncoder.GZIP.encode((Object)message.payload());
                    break;
                }
                case "identity": {
                    Buffer decoded;
                    if (message.encoding().equals("identity")) break;
                    if (!message.encoding().equals("gzip")) {
                        return Future.failedFuture((String)("Encoding " + message.encoding() + " is not supported"));
                    }
                    try {
                        decoded = (Buffer)GrpcMessageDecoder.GZIP.decode(message);
                    }
                    catch (CodecException e) {
                        return Future.failedFuture((Throwable)e);
                    }
                    message = GrpcMessage.message((String)"identity", (Buffer)decoded);
                }
            }
        }
        if (!this.headersSent) {
            ServiceName serviceName = this.serviceName;
            String methodName = this.methodName;
            if (serviceName == null) {
                throw new IllegalStateException();
            }
            if (methodName == null) {
                throw new IllegalStateException();
            }
            if (this.headers != null) {
                MultiMap requestHeaders = this.httpRequest.headers();
                for (Map.Entry header : this.headers) {
                    requestHeaders.add((String)header.getKey(), (String)header.getValue());
                }
            }
            String uri = serviceName.pathOf(methodName);
            this.httpRequest.putHeader("content-type", "application/grpc");
            if (this.encoding != null) {
                this.httpRequest.putHeader("grpc-encoding", this.encoding);
            }
            this.httpRequest.putHeader("grpc-accept-encoding", "gzip");
            this.httpRequest.putHeader("te", "trailers");
            this.httpRequest.setChunked(true);
            this.httpRequest.setURI(uri);
            this.headersSent = true;
        }
        if (end) {
            this.trailersSent = true;
            return this.httpRequest.end(GrpcMessageImpl.encode((GrpcMessage)message));
        }
        return this.httpRequest.write((Object)GrpcMessageImpl.encode((GrpcMessage)message));
    }

    public Future<Void> write(Req message) {
        return this.writeMessage(this.messageEncoder.encode(message));
    }

    public Future<Void> end(Req message) {
        return this.endMessage(this.messageEncoder.encode(message));
    }

    public void write(Req data, Handler<AsyncResult<Void>> handler) {
        this.write(data).onComplete(handler);
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }

    @Override
    public Future<GrpcClientResponse<Req, Resp>> response() {
        return this.response;
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        ContextInternal ctx = ((FutureInternal)this.response).context();
        ctx.execute(() -> {
            boolean responseEnded;
            if (this.response.failed()) {
                return;
            }
            if (this.response.succeeded()) {
                GrpcClientResponse resp = (GrpcClientResponse)this.response.result();
                if (resp.end().failed()) {
                    return;
                }
                responseEnded = resp.end().succeeded();
            } else {
                responseEnded = false;
            }
            if (!this.trailersSent || !responseEnded) {
                this.httpRequest.reset(GrpcError.CANCELLED.http2ResetCode);
            }
        });
    }

    @Override
    public HttpConnection connection() {
        return this.httpRequest.connection();
    }
}

