/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import io.vertx.core.MultiMap;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.Utils;
import java.util.List;

class MultiPart
extends EncodedPart {
    private final List<EncodedPart> parts;
    private final String boundary;

    public MultiPart(List<EncodedPart> parts, String mode, String userAgent) {
        this.parts = parts;
        this.boundary = Utils.generateBoundary(userAgent);
        this.headers = MultiMap.caseInsensitiveMultiMap();
        this.headers.set("Content-Type", "multipart/" + mode + "; boundary=\"" + this.boundary + "\"");
    }

    @Override
    String asString() {
        return this.partAsString(this);
    }

    private String partAsString(EncodedPart part) {
        StringBuilder sb = new StringBuilder();
        part.headers().forEach(header -> sb.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\n"));
        sb.append("\n");
        if (part.parts() != null) {
            for (EncodedPart thePart : part.parts()) {
                sb.append("--");
                sb.append(part.boundary());
                sb.append("\n");
                sb.append(this.partAsString(thePart));
                sb.append("\n\n");
            }
        } else {
            sb.append(part.body());
        }
        return sb.toString();
    }

    @Override
    public int size() {
        int size = 0;
        for (EncodedPart part : this.parts) {
            size += part.size();
        }
        return size;
    }

    @Override
    public List<EncodedPart> parts() {
        return this.parts;
    }

    @Override
    public String boundary() {
        return this.boundary;
    }
}

