/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@DataObject
public class MailMessage {
    private String bounceAddress;
    private String from;
    private List<String> to = null;
    private List<String> cc = null;
    private List<String> bcc = null;
    private String subject;
    private String text;
    private String html;
    private List<MailAttachment> inlineAttachment;
    private List<MailAttachment> attachment;
    private MultiMap headers = null;
    private boolean fixedHeaders = false;

    public MailMessage() {
    }

    public MailMessage(MailMessage other) {
        Objects.requireNonNull(other);
        this.bounceAddress = other.bounceAddress;
        this.from = other.from;
        this.to = this.copyList(other.to);
        this.cc = this.copyList(other.cc);
        this.bcc = this.copyList(other.bcc);
        this.subject = other.subject;
        this.text = other.text;
        this.html = other.html;
        this.fixedHeaders = other.fixedHeaders;
        if (other.attachment != null) {
            this.attachment = this.copyAttachments(other.attachment);
        }
        if (other.inlineAttachment != null) {
            this.inlineAttachment = this.copyAttachments(other.inlineAttachment);
        }
        if (other.headers != null) {
            this.headers = MultiMap.caseInsensitiveMultiMap().addAll(other.headers);
        }
    }

    private List<MailAttachment> copyAttachments(List<MailAttachment> attachment) {
        ArrayList<MailAttachment> newList = new ArrayList<MailAttachment>(attachment.size());
        for (MailAttachment a : attachment) {
            newList.add(MailAttachment.create(a));
        }
        return newList;
    }

    public MailMessage(JsonObject json) {
        Objects.requireNonNull(json);
        this.bounceAddress = json.getString("bounceAddress");
        this.from = json.getString("from");
        this.to = Utils.getKeyAsStringOrList(json, "to");
        this.cc = Utils.getKeyAsStringOrList(json, "cc");
        this.bcc = Utils.getKeyAsStringOrList(json, "bcc");
        this.subject = json.getString("subject");
        this.text = json.getString("text");
        this.html = json.getString("html");
        if (json.containsKey("inline_attachment")) {
            this.inlineAttachment = this.copyJsonAttachment(json.getValue("inline_attachment"));
        }
        if (json.containsKey("attachment")) {
            this.attachment = this.copyJsonAttachment(json.getValue("attachment"));
        }
        if (json.containsKey("headers")) {
            this.headers = Utils.jsonToMultiMap(json.getJsonObject("headers"));
        }
    }

    private List<MailAttachment> copyJsonAttachment(Object object) throws IllegalArgumentException {
        List<MailAttachment> list;
        if (object instanceof JsonObject) {
            list = Collections.singletonList(MailAttachment.create((JsonObject)object));
        } else if (object instanceof JsonArray) {
            list = new ArrayList<MailAttachment>();
            for (Object attach : (JsonArray)object) {
                list.add(MailAttachment.create((JsonObject)attach));
            }
        } else {
            throw new IllegalArgumentException("invalid attachment type");
        }
        return list;
    }

    public MailMessage(String from, String to, String subject, String text) {
        this.from = from;
        this.to = Utils.asList(to);
        this.subject = subject;
        this.text = text;
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public MailMessage setBounceAddress(String bounceAddress) {
        this.bounceAddress = bounceAddress;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MailMessage setFrom(String from) {
        this.from = from;
        return this;
    }

    public List<String> getTo() {
        return this.to;
    }

    public MailMessage setTo(List<String> to) {
        this.to = to;
        return this;
    }

    @GenIgnore
    public MailMessage setTo(String to) {
        this.to = Utils.asList(to);
        return this;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public MailMessage setCc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    @GenIgnore
    public MailMessage setCc(String cc) {
        this.cc = Utils.asList(cc);
        return this;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public MailMessage setBcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    @GenIgnore
    public MailMessage setBcc(String bcc) {
        this.bcc = Utils.asList(bcc);
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MailMessage setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MailMessage setText(String text) {
        this.text = text;
        return this;
    }

    public String getHtml() {
        return this.html;
    }

    public MailMessage setHtml(String html) {
        this.html = html;
        return this;
    }

    public List<MailAttachment> getAttachment() {
        return this.attachment;
    }

    public MailMessage setAttachment(List<MailAttachment> attachment) {
        this.attachment = attachment;
        return this;
    }

    @GenIgnore
    public MailMessage setAttachment(MailAttachment attachment) {
        this.attachment = Utils.asList(attachment);
        return this;
    }

    public List<MailAttachment> getInlineAttachment() {
        return this.inlineAttachment;
    }

    public MailMessage setInlineAttachment(List<MailAttachment> inlineAttachment) {
        this.inlineAttachment = inlineAttachment;
        return this;
    }

    @GenIgnore
    public MailMessage setInlineAttachment(MailAttachment inlineAttachment) {
        this.inlineAttachment = Utils.asList(inlineAttachment);
        return this;
    }

    public MailMessage addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    @GenIgnore
    public MailMessage setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    public boolean isFixedHeaders() {
        return this.fixedHeaders;
    }

    public MailMessage setFixedHeaders(boolean fixedHeaders) {
        this.fixedHeaders = fixedHeaders;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        Utils.putIfNotNull(json, "bounceAddress", this.bounceAddress);
        Utils.putIfNotNull(json, "from", this.from);
        Utils.putIfNotNull(json, "to", this.to);
        Utils.putIfNotNull(json, "cc", this.cc);
        Utils.putIfNotNull(json, "bcc", this.bcc);
        Utils.putIfNotNull(json, "subject", this.subject);
        Utils.putIfNotNull(json, "text", this.text);
        Utils.putIfNotNull(json, "html", this.html);
        if (this.attachment != null) {
            json.put("attachment", (Object)this.attachmentsToJson(this.attachment));
        }
        if (this.inlineAttachment != null) {
            json.put("inline_attachment", (Object)this.attachmentsToJson(this.inlineAttachment));
        }
        if (this.headers != null) {
            json.put("headers", (Object)Utils.multiMapToJson(this.headers));
        }
        if (this.fixedHeaders) {
            json.put("fixedheaders", (Object)true);
        }
        return json;
    }

    private JsonArray attachmentsToJson(List<MailAttachment> attachments) {
        JsonArray array = new JsonArray();
        for (MailAttachment a : attachments) {
            array.add((Object)a.toJson());
        }
        return array;
    }

    private List<Object> getList() {
        return Arrays.asList(this.bounceAddress, this.from, this.to, this.cc, this.bcc, this.subject, this.text, this.html, this.attachment, this.inlineAttachment, this.headers, this.fixedHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailMessage)) {
            return false;
        }
        MailMessage message = (MailMessage)o;
        return this.getList().equals(message.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    private List<String> copyList(List<String> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<String>(list);
    }
}

