/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;

class SMTPInitialDialogue {
    private static final Logger log = LoggerFactory.getLogger(SMTPInitialDialogue.class);
    private final SMTPConnection connection;
    private final Handler<Throwable> errorHandler;
    private final Handler<Void> finishedHandler;
    private final MailConfig config;
    private final String hostname;

    public SMTPInitialDialogue(SMTPConnection connection, MailConfig config, String hostname, Handler<Void> finishedHandler, Handler<Throwable> errorHandler) {
        this.connection = connection;
        this.config = config;
        this.hostname = hostname;
        this.finishedHandler = finishedHandler;
        this.errorHandler = errorHandler;
        this.connection.setErrorHandler(errorHandler);
    }

    public void start(String message) {
        SMTPResponse response = new SMTPResponse(message);
        if (response.isStatusOk()) {
            if (!this.config.isDisableEsmtp()) {
                this.ehloCmd();
            } else {
                this.heloCmd();
            }
        } else {
            this.handleError((Throwable)((Object)response.toException("got error response")));
        }
    }

    private void ehloCmd() {
        this.connection.write("EHLO " + this.hostname, (Handler<String>)((Handler)message -> {
            SMTPResponse response = new SMTPResponse((String)message);
            if (response.isStatusOk()) {
                this.connection.parseCapabilities((String)message);
                if (this.connection.getCapa().isStartTLS() && !this.connection.isSsl() && (this.config.getStarttls() == StartTLSOptions.REQUIRED || this.config.getStarttls() == StartTLSOptions.OPTIONAL)) {
                    this.startTLSCmd();
                } else {
                    this.finished();
                }
            } else {
                this.heloCmd();
            }
        }));
    }

    private void heloCmd() {
        this.connection.write("HELO " + this.hostname, (Handler<String>)((Handler)message -> {
            SMTPResponse response = new SMTPResponse((String)message);
            if (response.isStatusOk()) {
                this.finished();
            } else {
                this.handleError((Throwable)((Object)response.toException("HELO failed.")));
            }
        }));
    }

    private void handleError(Throwable throwable) {
        this.errorHandler.handle((Object)throwable);
    }

    private void startTLSCmd() {
        this.connection.write("STARTTLS", (Handler<String>)((Handler)message -> this.connection.upgradeToSsl((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.succeeded()) {
                log.trace((Object)"tls started");
                this.ehloCmd();
            } else {
                this.errorHandler.handle((Object)ar.cause());
            }
        }))));
    }

    private void finished() {
        if (this.connection.isSsl() || this.config.getStarttls() != StartTLSOptions.REQUIRED) {
            this.finishedHandler.handle(null);
        } else {
            log.warn((Object)"STARTTLS required but not supported by server");
            this.errorHandler.handle((Object)new NoStackTraceThrowable("STARTTLS required but not supported by server"));
        }
    }
}

