/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.MailClientImpl;
import java.util.UUID;

@VertxGen
public interface MailClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public static MailClient create(Vertx vertx, MailConfig config) {
        return new MailClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static MailClient createShared(Vertx vertx, MailConfig config, String poolName) {
        return new MailClientImpl(vertx, config, poolName);
    }

    public static MailClient createShared(Vertx vertx, MailConfig config) {
        return new MailClientImpl(vertx, config, DEFAULT_POOL_NAME);
    }

    @Fluent
    public MailClient sendMail(MailMessage var1, Handler<AsyncResult<MailResult>> var2);

    default public Future<MailResult> sendMail(MailMessage email) {
        Promise promise = Promise.promise();
        this.sendMail(email, (Handler<AsyncResult<MailResult>>)promise);
        return promise.future();
    }

    default public Future<Void> close() {
        Promise promise = Promise.promise();
        this.close((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    public void close(Handler<AsyncResult<Void>> var1);
}

