/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisURI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

class Slots {
    private static final Random RANDOM = new Random();
    private final int size;
    private final Slot[] slots;
    private final String[] endpoints;
    private final String[] masterEndpoints;

    Slots(String connectionString, Response reply) {
        int i;
        this.size = reply.size();
        this.slots = new Slot[this.size];
        RedisURI uri = new RedisURI(connectionString);
        HashSet<String> uniqueEndpoints = new HashSet<String>();
        ArrayList<String> masterEndpoints = new ArrayList<String>();
        for (i = 0; i < reply.size(); ++i) {
            Response s = reply.get(i);
            this.slots[i] = new Slot(s.get(0).toInteger(), s.get(1).toInteger(), s.size() - 2);
            for (int index = 2; index < s.size(); ++index) {
                String endpoint;
                Response c = s.get(index);
                String host = c.get(0).toString().contains(":") ? "[" + c.get(0).toString() + "]" : c.get(0).toString();
                ((Slot)this.slots[i]).endpoints[index - 2] = endpoint = uri.protocol() + "://" + uri.userinfo() + host + ":" + c.get(1).toInteger();
                uniqueEndpoints.add(endpoint);
                if (index != 2) continue;
                masterEndpoints.add(endpoint);
            }
        }
        this.endpoints = new String[uniqueEndpoints.size()];
        i = 0;
        for (String endpoint : uniqueEndpoints) {
            this.endpoints[i++] = endpoint;
        }
        this.masterEndpoints = masterEndpoints.toArray(new String[masterEndpoints.size()]);
    }

    boolean contains(String endpoint) {
        for (String entry : this.endpoints) {
            if (!endpoint.equals(entry)) continue;
            return true;
        }
        return false;
    }

    int size() {
        return this.size;
    }

    String[] endpointsForSlot(int index) {
        return this.slots[index].endpoints;
    }

    String[] endpointsForKey(int key) {
        for (Slot s : this.slots) {
            if (key < s.start || key > s.end) continue;
            return s.endpoints;
        }
        return null;
    }

    String randomEndPoint(boolean onlyMasterEndpoints) {
        if (onlyMasterEndpoints) {
            return this.masterEndpoints[RANDOM.nextInt(this.masterEndpoints.length)];
        }
        return this.endpoints[RANDOM.nextInt(this.endpoints.length)];
    }

    String[] endpoints() {
        return this.endpoints;
    }

    static class Slot {
        private final int start;
        private final int end;
        private final String[] endpoints;

        Slot(int start, int end, int size) {
            this.start = start;
            this.end = end;
            this.endpoints = new String[size];
        }
    }
}

