/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.impl.RequestImpl;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@VertxGen
public interface Request {
    public static Request cmd(Command command) {
        return new RequestImpl(command);
    }

    @GenIgnore(value={"permitted-type"})
    public static Request cmd(Command command, Object ... args) {
        return new RequestImpl(command, args);
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public Request arg(byte[] var1);

    @Fluent
    default public Request arg(String arg) {
        if (arg == null) {
            return this.nullArg();
        }
        return this.arg(arg.getBytes(StandardCharsets.UTF_8));
    }

    @Fluent
    default public Request arg(String arg, String enc) {
        if (arg == null) {
            return this.nullArg();
        }
        return this.arg(arg.getBytes(Charset.forName(enc)));
    }

    @Fluent
    public Request arg(Buffer var1);

    @Fluent
    public Request arg(long var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public Request arg(int arg) {
        this.arg((long)arg);
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public Request arg(short arg) {
        this.arg((long)arg);
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public Request arg(byte arg) {
        this.arg((long)arg);
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public Request arg(float arg) {
        this.arg(Float.toString(arg));
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public Request arg(double arg) {
        this.arg(Double.toString(arg));
        return this;
    }

    @Fluent
    public Request arg(boolean var1);

    @Fluent
    default public Request arg(JsonObject arg) {
        if (arg == null) {
            this.nullArg();
        } else {
            for (Map.Entry kv : arg) {
                this.arg((String)kv.getKey());
                Object val = kv.getValue();
                if (val == null) {
                    this.nullArg();
                    continue;
                }
                if (val instanceof Buffer) {
                    this.arg((Buffer)val);
                    continue;
                }
                if (val instanceof JsonArray || val instanceof JsonObject) {
                    throw new IllegalArgumentException("Graph objects are not allowed as values, only simple types");
                }
                this.arg(val.toString());
            }
        }
        return this;
    }

    @Fluent
    default public Request arg(JsonArray arg) {
        if (arg == null) {
            this.nullArg();
        } else {
            for (Object el : arg) {
                if (el == null) {
                    this.nullArg();
                    continue;
                }
                if (el instanceof Buffer) {
                    this.arg((Buffer)el);
                    continue;
                }
                if (el instanceof JsonArray || el instanceof JsonObject) {
                    throw new IllegalArgumentException("Graph objects are not allowed as elements, only simple types");
                }
                this.arg(el.toString());
            }
        }
        return this;
    }

    @Fluent
    @Deprecated
    public Request nullArg();

    public Command command();
}

