/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.CommandReporter;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import java.util.List;

public class PooledRedisConnection
implements RedisConnection {
    private final Lease<RedisConnectionInternal> lease;
    private final RedisConnectionInternal connection;
    private final PoolMetrics metrics;
    private final Object metric;

    public PooledRedisConnection(Lease<RedisConnectionInternal> lease, PoolMetrics<?> poolMetrics, Object metric) {
        this.lease = lease;
        this.connection = (RedisConnectionInternal)lease.get();
        this.metrics = poolMetrics;
        this.metric = metric;
    }

    public RedisConnectionInternal actual() {
        return this.connection;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.connection.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.connection.handler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.connection.resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.connection.fetch(amount);
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
        this.connection.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        CommandReporter reporter = new CommandReporter(this.connection, command.command().toString());
        reporter.before();
        return this.connection.send(command).andThen(reporter::after);
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        CommandReporter reporter = new CommandReporter(this.connection, "batch");
        reporter.before();
        return this.connection.batch(commands).andThen(reporter::after);
    }

    @Override
    public Future<Void> close() {
        if (this.connection.reset()) {
            this.lease.recycle();
            if (this.metrics != null) {
                this.metrics.end(this.metric, true);
            }
        }
        return Future.succeededFuture();
    }

    @Override
    public boolean pendingQueueFull() {
        return this.connection.pendingQueueFull();
    }
}

