/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.amqp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Once connected to the broker or router, you get a connection. This connection is automatically opened.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpConnection that = (AmqpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection) obj),
    AmqpConnection::getDelegate
  );

  private final io.vertx.amqp.AmqpConnection delegate;
  
  public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
    this.delegate = delegate;
  }

  public AmqpConnection(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
  }

  public io.vertx.amqp.AmqpConnection getDelegate() {
    return delegate;
  }

  /**
   * Registers a handler called on disconnection.
   * @param handler the exception handler.
   * @return 
   */
  public io.vertx.rxjava.amqp.AmqpConnection exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * @param done the close handler notified when the connection is closed. May be <code>null</code>.
   * @return the connection
   */
  public io.vertx.rxjava.amqp.AmqpConnection close(Handler<AsyncResult<Void>> done) { 
    delegate.close(done);
    return this;
  }

    /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * @return the connection
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @param completionHandler the handler called with the receiver. The receiver has been opened.
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createReceiver(String address, Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpReceiver> rxCreateReceiver(String address) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createReceiver(address, fut);
    }));
  }

  /**
   * Creates a receiver used to consumer messages from the given address.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @param completionHandler The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createReceiver(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions, Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, receiverOptions, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates a receiver used to consumer messages from the given address.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpReceiver> rxCreateReceiver(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createReceiver(address, receiverOptions, fut);
    }));
  }

  /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.rxjava.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * @param completionHandler the completion handler, called when the receiver has been created and opened.
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createDynamicReceiver(Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createDynamicReceiver(new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.rxjava.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpReceiver> rxCreateDynamicReceiver() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createDynamicReceiver(fut);
    }));
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.rxjava.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param completionHandler The handler called with the sender, once opened
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createSender(String address, Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.rxjava.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpSender> rxCreateSender(String address) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createSender(address, fut);
    }));
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.rxjava.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @param completionHandler The handler called with the sender, once opened
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createSender(String address, io.vertx.amqp.AmqpSenderOptions options, Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, options, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.rxjava.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpSender> rxCreateSender(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createSender(address, options, fut);
    }));
  }

  /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * @param completionHandler The handler called with the created sender, once opened
   * @return the connection.
   */
  public io.vertx.rxjava.amqp.AmqpConnection createAnonymousSender(Handler<AsyncResult<io.vertx.rxjava.amqp.AmqpSender>> completionHandler) { 
    delegate.createAnonymousSender(new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * @return the connection.
   */
  public Single<io.vertx.rxjava.amqp.AmqpSender> rxCreateAnonymousSender() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createAnonymousSender(fut);
    }));
  }

  /**
   * @return whether the connection has been disconnected.
   */
  public boolean isDisconnected() { 
    boolean ret = delegate.isDisconnected();
    return ret;
  }

  public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
    return arg != null ? new AmqpConnection(arg) : null;
  }

}
