/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.amqp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface used to consume AMQP message as a stream of message.
 * Back pressure is implemented using AMQP credits.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpReceiver original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpReceiver.class)
public class AmqpReceiver implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpReceiver that = (AmqpReceiver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpReceiver> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpReceiver((io.vertx.amqp.AmqpReceiver) obj),
    AmqpReceiver::getDelegate
  );

  private final io.vertx.amqp.AmqpReceiver delegate;
  
  public AmqpReceiver(io.vertx.amqp.AmqpReceiver delegate) {
    this.delegate = delegate;
  }

  public AmqpReceiver(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpReceiver)delegate;
  }

  public io.vertx.amqp.AmqpReceiver getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.amqp.AmqpMessage> observable;

  public synchronized Observable<io.vertx.rxjava.amqp.AmqpMessage> toObservable() {
    if (observable == null) {
      Function<io.vertx.amqp.AmqpMessage, io.vertx.rxjava.amqp.AmqpMessage> conv = io.vertx.rxjava.amqp.AmqpMessage::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.amqp.AmqpMessage>(o1 -> io.vertx.rxjava.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.amqp.AmqpMessage> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.amqp.AmqpMessage> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.amqp.AmqpMessage> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.amqp.AmqpMessage> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.amqp.AmqpMessage> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.amqp.AmqpReceiver exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpReceiver handler(Handler<io.vertx.rxjava.amqp.AmqpMessage> handler) { 
    delegate.handler(new Handler<io.vertx.amqp.AmqpMessage>() {
      public void handle(io.vertx.amqp.AmqpMessage event) {
        handler.handle(io.vertx.rxjava.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpReceiver pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpReceiver resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpReceiver fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpReceiver endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * The listened address.
   * @return the address, not <code>null</code>
   */
  public String address() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.address();
    cached_0 = ret;
    return ret;
  }

  /**
   * Closes the receiver.
   * @param handler handler called when the receiver has been closed, can be <code>null</code>
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Closes the receiver.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Gets the connection having created the receiver. Cannot be <code>null</code>
   * @return the connection having created the receiver.
   */
  public io.vertx.rxjava.amqp.AmqpConnection connection() { 
    io.vertx.rxjava.amqp.AmqpConnection ret = io.vertx.rxjava.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  private String cached_0;
  public static AmqpReceiver newInstance(io.vertx.amqp.AmqpReceiver arg) {
    return arg != null ? new AmqpReceiver(arg) : null;
  }

}
