/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.amqp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Sender interface used to send messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpSender original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpSender.class)
public class AmqpSender implements io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpSender that = (AmqpSender) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpSender((io.vertx.amqp.AmqpSender) obj),
    AmqpSender::getDelegate
  );

  private final io.vertx.amqp.AmqpSender delegate;
  
  public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
    this.delegate = delegate;
  }

  public AmqpSender(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpSender)delegate;
  }

  public io.vertx.amqp.AmqpSender getDelegate() {
    return delegate;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.amqp.AmqpMessage> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.amqp.AmqpMessage> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.rxjava.amqp.AmqpMessage::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.amqp.AmqpMessage>(o1 -> io.vertx.rxjava.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

    /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Single<Void> rxEnd() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.rxjava.amqp.AmqpMessage data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxEnd(io.vertx.rxjava.amqp.AmqpMessage data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.amqp.AmqpSender#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See  for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.amqp.AmqpMessage> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpSender write(io.vertx.rxjava.amqp.AmqpMessage data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpSender write(io.vertx.rxjava.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

    public Single<Void> rxWrite(io.vertx.rxjava.amqp.AmqpMessage data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  public io.vertx.rxjava.amqp.AmqpSender exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.amqp.AmqpSender setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * Sends an AMQP message. The destination the configured sender address or the address configured in the message.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.rxjava.amqp.AmqpSender send(io.vertx.rxjava.amqp.AmqpMessage message) { 
    delegate.send(message.getDelegate());
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @param acknowledgementHandler the acknowledgement handler, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.rxjava.amqp.AmqpSender sendWithAck(io.vertx.rxjava.amqp.AmqpMessage message, Handler<AsyncResult<Void>> acknowledgementHandler) { 
    delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
    return this;
  }

    /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public Single<Void> rxSendWithAck(io.vertx.rxjava.amqp.AmqpMessage message) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sendWithAck(message, fut);
    }));
  }

  /**
   * Closes the sender.
   * @param handler called when the sender has been closed, must not be <code>null</code>
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Closes the sender.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * @return the configured address.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Gets the connection having created the sender. Cannot be <code>null</code>
   * @return the connection having created the sender.
   */
  public io.vertx.rxjava.amqp.AmqpConnection connection() { 
    io.vertx.rxjava.amqp.AmqpConnection ret = io.vertx.rxjava.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the remaining credit, 0 is none.
   */
  public long remainingCredits() { 
    long ret = delegate.remainingCredits();
    return ret;
  }

  public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
    return arg != null ? new AmqpSender(arg) : null;
  }

}
