/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.cassandra;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * It is like , but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.MappingManager original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.MappingManager.class)
public class MappingManager {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MappingManager that = (MappingManager) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MappingManager> __TYPE_ARG = new TypeArg<>(    obj -> new MappingManager((io.vertx.cassandra.MappingManager) obj),
    MappingManager::getDelegate
  );

  private final io.vertx.cassandra.MappingManager delegate;
  
  public MappingManager(io.vertx.cassandra.MappingManager delegate) {
    this.delegate = delegate;
  }

  public MappingManager(Object delegate) {
    this.delegate = (io.vertx.cassandra.MappingManager)delegate;
  }

  public io.vertx.cassandra.MappingManager getDelegate() {
    return delegate;
  }


  /**
   * Create a {@link io.vertx.rxjava.cassandra.MappingManager} from the given {@link io.vertx.rxjava.cassandra.CassandraClient}.
   * @param client a Cassandra client instance
   * @return 
   */
  public static io.vertx.rxjava.cassandra.MappingManager create(io.vertx.rxjava.cassandra.CassandraClient client) { 
    io.vertx.rxjava.cassandra.MappingManager ret = io.vertx.rxjava.cassandra.MappingManager.newInstance((io.vertx.cassandra.MappingManager)io.vertx.cassandra.MappingManager.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create a {@link io.vertx.rxjava.cassandra.Mapper} that allows conversion of domain classes to and from query results.
   * @param mappedClass mapped class
   * @return 
   */
  public <T> io.vertx.rxjava.cassandra.Mapper<T> mapper(java.lang.Class<T> mappedClass) { 
    io.vertx.rxjava.cassandra.Mapper<T> ret = io.vertx.rxjava.cassandra.Mapper.newInstance((io.vertx.cassandra.Mapper)delegate.mapper(io.vertx.lang.rxjava.Helper.unwrap(mappedClass)), TypeArg.of(mappedClass));
    return ret;
  }

  public static MappingManager newInstance(io.vertx.cassandra.MappingManager arg) {
    return arg != null ? new MappingManager(arg) : null;
  }

}
