/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.datagram;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A datagram socket can be used to send {@link io.vertx.rxjava.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.rxjava.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.datagram.DatagramPacket>, io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  public DatagramSocket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
  }

  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.datagram.DatagramPacket> observable;

  public synchronized Observable<io.vertx.rxjava.core.datagram.DatagramPacket> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.datagram.DatagramPacket, io.vertx.rxjava.core.datagram.DatagramPacket> conv = io.vertx.rxjava.core.datagram.DatagramPacket::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.core.datagram.DatagramPacket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.datagram.DatagramPacket>(o1 -> io.vertx.rxjava.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.datagram.DatagramPacket> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.datagram.DatagramPacket> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.send(packet.getDelegate(), port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSend} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> sendObservable(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    send(packet, port, host, handler.toHandler());
    return handler;
  }

  /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxSend(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      send(packet, port, host, fut);
    }));
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.rxjava.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> sender(int port, String host) { 
    io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.WriteStream.newInstance((io.vertx.core.streams.WriteStream)delegate.sender(port, host), TYPE_ARG_1);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(String str, int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSend} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> sendObservable(String str, int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    send(str, port, host, handler.toHandler());
    return handler;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxSend(String str, int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      send(str, port, host, fut);
    }));
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, enc, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSend} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> sendObservable(String str, String enc, int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    send(str, enc, port, host, handler.toHandler());
    return handler;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxSend(String str, String enc, int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      send(str, enc, port, host, fut);
    }));
  }

  /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @param handler the handler to notify once complete
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(handler.toHandler());
    return handler;
  }

  /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket}. The close itself is asynchronous.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Return the {@link io.vertx.rxjava.core.net.SocketAddress} to which
   * this {@link io.vertx.rxjava.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListenMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> listenMulticastGroupObservable(String multicastAddress) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    listenMulticastGroup(multicastAddress, handler.toHandler());
    return handler;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxListenMulticastGroup(String multicastAddress) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listenMulticastGroup(multicastAddress, fut);
    }));
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListenMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> listenMulticastGroupObservable(String multicastAddress, String networkInterface, String source) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    listenMulticastGroup(multicastAddress, networkInterface, source, handler.toHandler());
    return handler;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listenMulticastGroup(multicastAddress, networkInterface, source, fut);
    }));
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxUnlistenMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> unlistenMulticastGroupObservable(String multicastAddress) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    unlistenMulticastGroup(multicastAddress, handler.toHandler());
    return handler;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unlistenMulticastGroup(multicastAddress, fut);
    }));
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxUnlistenMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> unlistenMulticastGroupObservable(String multicastAddress, String networkInterface, String source) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    unlistenMulticastGroup(multicastAddress, networkInterface, source, handler.toHandler());
    return handler;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unlistenMulticastGroup(multicastAddress, networkInterface, source, fut);
    }));
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxBlockMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> blockMulticastGroupObservable(String multicastAddress, String sourceToBlock) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    blockMulticastGroup(multicastAddress, sourceToBlock, handler.toHandler());
    return handler;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      blockMulticastGroup(multicastAddress, sourceToBlock, fut);
    }));
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxBlockMulticastGroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> blockMulticastGroupObservable(String multicastAddress, String networkInterface, String sourceToBlock) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler.toHandler());
    return handler;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, fut);
    }));
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param handler the handler will be called when listening
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listen(int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.datagram.DatagramSocket> listenObservable(int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.datagram.DatagramSocket> handler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(port, host, handler.toHandler());
    return handler;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxListen(int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(port, host, fut);
    }));
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket handler(Handler<io.vertx.rxjava.core.datagram.DatagramPacket> handler) { 
    delegate.handler(new Handler<io.vertx.core.datagram.DatagramPacket>() {
      public void handle(io.vertx.core.datagram.DatagramPacket event) {
        handler.handle(io.vertx.rxjava.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  private io.vertx.rxjava.core.net.SocketAddress cached_0;
  public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
