/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.rxjava.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.rxjava.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  public HttpServer(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServer)delegate;
  }

  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.core.http.HttpServerRequest> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.http.HttpServerRequest>(o1 -> io.vertx.rxjava.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.core.http.ServerWebSocket> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.core.http.ServerWebSocket>(o1 -> io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.core.http.ServerWebSocket> TYPE_ARG_2 = new TypeArg<io.vertx.rxjava.core.http.ServerWebSocket>(o1 -> io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the request stream for the server. As HTTP requests are received by the server,
   * instances of {@link io.vertx.rxjava.core.http.HttpServerRequest} will be created and passed to the stream .
   * @return the request stream
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.HttpServerRequest> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.requestStream(), TYPE_ARG_0);
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.rxjava.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer requestHandler(Handler<io.vertx.rxjava.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.rxjava.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event));
      }
    });
    return this;
  }

  /**
   * Set a connection handler for the server.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer connectionHandler(Handler<io.vertx.rxjava.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.rxjava.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event));
      }
    });
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Return the WebSocket stream for the server. If a webSocket connect handshake is successful a
   * new {@link io.vertx.rxjava.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  @Deprecated()
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> websocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.websocketStream(), TYPE_ARG_1);
    cached_1 = ret;
    return ret;
  }

  /**
   * Return the WebSocket stream for the server. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.rxjava.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.webSocketStream(), TYPE_ARG_2);
    cached_2 = ret;
    return ret;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.rxjava.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava.core.http.HttpServer websocketHandler(Handler<io.vertx.rxjava.core.http.ServerWebSocket> handler) { 
    delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.rxjava.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer webSocketHandler(Handler<io.vertx.rxjava.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified in the
   * {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified here,
   * ignoring any value set in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer listen(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.rxjava.core.http.HttpServer listen(int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.http.HttpServer> listenObservable(int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.http.HttpServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(port, host, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public Single<io.vertx.rxjava.core.http.HttpServer> rxListen(int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(port, host, fut);
    }));
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.rxjava.core.http.HttpServer listen(io.vertx.rxjava.core.net.SocketAddress address, Handler<AsyncResult<io.vertx.rxjava.core.http.HttpServer>> listenHandler) { 
    delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.http.HttpServer> listenObservable(io.vertx.rxjava.core.net.SocketAddress address) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.http.HttpServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(address, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public Single<io.vertx.rxjava.core.http.HttpServer> rxListen(io.vertx.rxjava.core.net.SocketAddress address) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(address, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but the server will listen on host "0.0.0.0" and port specified here ignoring
   * any value in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.HttpServer listen(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.rxjava.core.http.HttpServer listen(int port, Handler<AsyncResult<io.vertx.rxjava.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.http.HttpServer> listenObservable(int port) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.http.HttpServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(port, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public Single<io.vertx.rxjava.core.http.HttpServer> rxListen(int port) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(port, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.rxjava.core.http.HttpServer listen(Handler<AsyncResult<io.vertx.rxjava.core.http.HttpServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.http.HttpServer> listenObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.http.HttpServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public Single<io.vertx.rxjava.core.http.HttpServer> rxListen() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(fut);
    }));
  }

  /**
   * Close the server. Any open HTTP connections will be closed.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @param completionHandler the handler
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

    /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  private io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.HttpServerRequest> cached_0;
  private io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> cached_1;
  private io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.http.ServerWebSocket> cached_2;
  public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
