/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.shareddata;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.rxjava.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncMap> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later with the async result.
   */
  public void get(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.get(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   * @deprecated use {@link #rxGet} instead
   */
  @Deprecated()
  public Observable<V> getObservable(K k) { 
    io.vertx.rx.java.ObservableFuture<V> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    get(k, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Single<V> rxGet(K k) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      get(k, fut);
    }));
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @param completionHandler - this will be called some time later to signify the value has been put
   */
  public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), completionHandler);
  }

    /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   * @deprecated use {@link #rxPut} instead
   */
  @Deprecated()
  public Observable<Void> putObservable(K k, V v) { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    put(k, v, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Single<Void> rxPut(K k, V v) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      put(k, v, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, completionHandler);
  }

    /**
   * Like {@link io.vertx.rxjava.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   * @deprecated use {@link #rxPut} instead
   */
  @Deprecated()
  public Observable<Void> putObservable(K k, V v, long ttl) { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    put(k, v, ttl, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Single<Void> rxPut(K k, V v, long ttl) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      put(k, v, ttl, fut);
    }));
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   * @deprecated use {@link #rxPutIfAbsent} instead
   */
  @Deprecated()
  public Observable<V> putIfAbsentObservable(K k, V v) { 
    io.vertx.rx.java.ObservableFuture<V> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    putIfAbsent(k, v, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Single<V> rxPutIfAbsent(K k, V v) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      putIfAbsent(k, v, fut);
    }));
  }

  /**
   * Link {@link io.vertx.rxjava.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Link {@link io.vertx.rxjava.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   * @deprecated use {@link #rxPutIfAbsent} instead
   */
  @Deprecated()
  public Observable<V> putIfAbsentObservable(K k, V v, long ttl) { 
    io.vertx.rx.java.ObservableFuture<V> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    putIfAbsent(k, v, ttl, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Link {@link io.vertx.rxjava.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Single<V> rxPutIfAbsent(K k, V v, long ttl) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      putIfAbsent(k, v, ttl, fut);
    }));
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void remove(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.remove(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   * @deprecated use {@link #rxRemove} instead
   */
  @Deprecated()
  public Observable<V> removeObservable(K k) { 
    io.vertx.rx.java.ObservableFuture<V> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    remove(k, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Single<V> rxRemove(K k) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      remove(k, fut);
    }));
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), resultHandler);
  }

    /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   * @deprecated use {@link #rxRemoveIfPresent} instead
   */
  @Deprecated()
  public Observable<Boolean> removeIfPresentObservable(K k, V v) { 
    io.vertx.rx.java.ObservableFuture<Boolean> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    removeIfPresent(k, v, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Single<Boolean> rxRemoveIfPresent(K k, V v) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      removeIfPresent(k, v, fut);
    }));
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param resultHandler the result handler will be passed the previous value
   */
  public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) { 
    delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   * @deprecated use {@link #rxReplace} instead
   */
  @Deprecated()
  public Observable<V> replaceObservable(K k, V v) { 
    io.vertx.rx.java.ObservableFuture<V> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    replace(k, v, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public Single<V> rxReplace(K k, V v) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      replace(k, v, fut);
    }));
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param resultHandler the result handler
   */
  public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), resultHandler);
  }

    /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   * @deprecated use {@link #rxReplaceIfPresent} instead
   */
  @Deprecated()
  public Observable<Boolean> replaceIfPresentObservable(K k, V oldValue, V newValue) { 
    io.vertx.rx.java.ObservableFuture<Boolean> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    replaceIfPresent(k, oldValue, newValue, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      replaceIfPresent(k, oldValue, newValue, fut);
    }));
  }

  /**
   * Clear all entries in the map
   * @param resultHandler called on completion
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

    /**
   * Clear all entries in the map
   * @return 
   * @deprecated use {@link #rxClear} instead
   */
  @Deprecated()
  public Observable<Void> clearObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    clear(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public Single<Void> rxClear() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      clear(fut);
    }));
  }

  /**
   * Provide the number of entries in the map
   * @param resultHandler handler which will receive the number of entries
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

    /**
   * Provide the number of entries in the map
   * @return 
   * @deprecated use {@link #rxSize} instead
   */
  @Deprecated()
  public Observable<Integer> sizeObservable() { 
    io.vertx.rx.java.ObservableFuture<Integer> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    size(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public Single<Integer> rxSize() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      size(fut);
    }));
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
