/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.shareddata;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SharedData> __TYPE_ARG = new TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  public SharedData(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.SharedData)delegate;
  }

  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }


  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getClusterWideMap(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getClusterWideMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return 
   * @deprecated use {@link #rxGetClusterWideMap} instead
   */
  @Deprecated()
  public <K, V> Observable<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> getClusterWideMapObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getClusterWideMap(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> rxGetClusterWideMap(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getClusterWideMap(name, fut);
    }));
  }

  /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getAsyncMap(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return 
   * @deprecated use {@link #rxGetAsyncMap} instead
   */
  @Deprecated()
  public <K, V> Observable<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> getAsyncMapObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getAsyncMap(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> rxGetAsyncMap(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getAsyncMap(name, fut);
    }));
  }

  /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getLocalAsyncMap(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getLocalAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K, V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return 
   * @deprecated use {@link #rxGetLocalAsyncMap} instead
   */
  @Deprecated()
  public <K, V> Observable<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> getLocalAsyncMapObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLocalAsyncMap(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the {@link io.vertx.rxjava.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.rxjava.core.shareddata.AsyncMap<K, V>> rxGetLocalAsyncMap(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLocalAsyncMap(name, fut);
    }));
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  public void getLock(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Lock>> resultHandler) { 
    delegate.getLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   * @deprecated use {@link #rxGetLock} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Lock> getLockObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Lock> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLock(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Lock> rxGetLock(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLock(name, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Lock>> resultHandler) { 
    delegate.getLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   * @deprecated use {@link #rxGetLockWithTimeout} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Lock> getLockWithTimeoutObservable(String name, long timeout) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Lock> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLockWithTimeout(name, timeout, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Lock> rxGetLockWithTimeout(String name, long timeout) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLockWithTimeout(name, timeout, fut);
    }));
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  public void getLocalLock(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   * @deprecated use {@link #rxGetLocalLock} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Lock> getLocalLockObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Lock> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLocalLock(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Lock> rxGetLocalLock(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLocalLock(name, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  public void getLocalLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   * @deprecated use {@link #rxGetLocalLockWithTimeout} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Lock> getLocalLockWithTimeoutObservable(String name, long timeout) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Lock> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLocalLockWithTimeout(name, timeout, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Lock> rxGetLocalLockWithTimeout(String name, long timeout) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLocalLockWithTimeout(name, timeout, fut);
    }));
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  public void getCounter(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Counter>> resultHandler) { 
    delegate.getCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   * @deprecated use {@link #rxGetCounter} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Counter> getCounterObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Counter> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getCounter(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Counter> rxGetCounter(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getCounter(name, fut);
    }));
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  public void getLocalCounter(String name, Handler<AsyncResult<io.vertx.rxjava.core.shareddata.Counter>> resultHandler) { 
    delegate.getLocalCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   * @deprecated use {@link #rxGetLocalCounter} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.shareddata.Counter> getLocalCounterObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.shareddata.Counter> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getLocalCounter(name, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public Single<io.vertx.rxjava.core.shareddata.Counter> rxGetLocalCounter(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getLocalCounter(name, fut);
    }));
  }

  /**
   * Return a <code>LocalMap</code> with the specific <code>name</code>.
   * @param name the name of the map
   * @return the msp
   */
  public <K, V> io.vertx.rxjava.core.shareddata.LocalMap<K, V> getLocalMap(String name) { 
    io.vertx.rxjava.core.shareddata.LocalMap<K, V> ret = io.vertx.rxjava.core.shareddata.LocalMap.newInstance((io.vertx.core.shareddata.LocalMap)delegate.getLocalMap(name), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }

}
