/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.asyncsql;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an asynchronous MySQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.MySQLClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.asyncsql.MySQLClient.class)
public class MySQLClient extends io.vertx.rxjava.ext.asyncsql.AsyncSQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLClient that = (MySQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MySQLClient> __TYPE_ARG = new TypeArg<>(    obj -> new MySQLClient((io.vertx.ext.asyncsql.MySQLClient) obj),
    MySQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.MySQLClient delegate;
  
  public MySQLClient(io.vertx.ext.asyncsql.MySQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLClient(Object delegate) {
    super((io.vertx.ext.asyncsql.MySQLClient)delegate);
    this.delegate = (io.vertx.ext.asyncsql.MySQLClient)delegate;
  }

  public io.vertx.ext.asyncsql.MySQLClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

    /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   * @deprecated use {@link #rxQuerySingle} instead
   */
  @Deprecated()
  public Observable<JsonArray> querySingleObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingle(sql, handler.toHandler());
    return handler;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public Single<JsonArray> rxQuerySingle(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingle(sql, fut);
    }));
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

    /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   * @deprecated use {@link #rxQuerySingleWithParams} instead
   */
  @Deprecated()
  public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingleWithParams(sql, arguments, handler.toHandler());
    return handler;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingleWithParams(sql, arguments, fut);
    }));
  }

  /**
   * Create a MySQL client which maintains its own pool.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.asyncsql.AsyncSQLClient createNonShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) { 
    io.vertx.rxjava.ext.asyncsql.AsyncSQLClient ret = io.vertx.rxjava.ext.asyncsql.AsyncSQLClient.newInstance((io.vertx.ext.asyncsql.AsyncSQLClient)io.vertx.ext.asyncsql.MySQLClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a MySQL client which shares its data source with any other MySQL clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static io.vertx.rxjava.ext.asyncsql.AsyncSQLClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config, String poolName) { 
    io.vertx.rxjava.ext.asyncsql.AsyncSQLClient ret = io.vertx.rxjava.ext.asyncsql.AsyncSQLClient.newInstance((io.vertx.ext.asyncsql.AsyncSQLClient)io.vertx.ext.asyncsql.MySQLClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.asyncsql.MySQLClient#createShared} but with the default pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.asyncsql.AsyncSQLClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) { 
    io.vertx.rxjava.ext.asyncsql.AsyncSQLClient ret = io.vertx.rxjava.ext.asyncsql.AsyncSQLClient.newInstance((io.vertx.ext.asyncsql.AsyncSQLClient)io.vertx.ext.asyncsql.MySQLClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * The default name used for the MySQL pool.
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_POOL_NAME;
  /**
   * The default host.
   */
  public static final String DEFAULT_HOST = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_HOST;
  /**
   * The default port.
   */
  public static final int DEFAULT_PORT = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_PORT;
  /**
   * The default database.
   */
  public static final String DEFAULT_DATABASE = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_DATABASE;
  /**
   * The default database user.
   */
  public static final String DEFAULT_USER = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_USER;
  /**
   * The default database password.
   */
  public static final String DEFAULT_PASSWORD = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_PASSWORD;
  /**
   * The default charset.
   */
  public static final String DEFAULT_CHARSET = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_CHARSET;
  /**
   * The default timeout for connect.
   */
  public static final long DEFAULT_CONNECT_TIMEOUT = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_CONNECT_TIMEOUT;
  /**
   * The default timeout for tests.
   */
  public static final long DEFAULT_TEST_TIMEOUT = io.vertx.ext.asyncsql.MySQLClient.DEFAULT_TEST_TIMEOUT;
  public static MySQLClient newInstance(io.vertx.ext.asyncsql.MySQLClient arg) {
    return arg != null ? new MySQLClient(arg) : null;
  }

}
