/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * User-facing interface for authenticating users.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.AuthProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.AuthProvider.class)
public class AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthProvider that = (AuthProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthProvider> __TYPE_ARG = new TypeArg<>(    obj -> new AuthProvider((io.vertx.ext.auth.AuthProvider) obj),
    AuthProvider::getDelegate
  );

  private final io.vertx.ext.auth.AuthProvider delegate;
  
  public AuthProvider(io.vertx.ext.auth.AuthProvider delegate) {
    this.delegate = delegate;
  }

  public AuthProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.AuthProvider)delegate;
  }

  public io.vertx.ext.auth.AuthProvider getDelegate() {
    return delegate;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @param resultHandler The result handler
   */
  public void authenticate(JsonObject authInfo, Handler<AsyncResult<io.vertx.rxjava.ext.auth.User>> resultHandler) { 
    delegate.authenticate(authInfo, new Handler<AsyncResult<io.vertx.ext.auth.User>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @return 
   * @deprecated use {@link #rxAuthenticate} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.User> authenticateObservable(JsonObject authInfo) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.User> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    authenticate(authInfo, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @return 
   */
  public Single<io.vertx.rxjava.ext.auth.User> rxAuthenticate(JsonObject authInfo) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      authenticate(authInfo, fut);
    }));
  }

  public static AuthProvider newInstance(io.vertx.ext.auth.AuthProvider arg) {
    return arg != null ? new AuthProvider(arg) : null;
  }

}
