/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.shiro;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating Apache Shiro based {@link io.vertx.rxjava.ext.auth.AuthProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.shiro.ShiroAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.shiro.ShiroAuth.class)
public class ShiroAuth extends io.vertx.rxjava.ext.auth.AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShiroAuth that = (ShiroAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ShiroAuth> __TYPE_ARG = new TypeArg<>(    obj -> new ShiroAuth((io.vertx.ext.auth.shiro.ShiroAuth) obj),
    ShiroAuth::getDelegate
  );

  private final io.vertx.ext.auth.shiro.ShiroAuth delegate;
  
  public ShiroAuth(io.vertx.ext.auth.shiro.ShiroAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ShiroAuth(Object delegate) {
    super((io.vertx.ext.auth.shiro.ShiroAuth)delegate);
    this.delegate = (io.vertx.ext.auth.shiro.ShiroAuth)delegate;
  }

  public io.vertx.ext.auth.shiro.ShiroAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a Shiro auth provider
   * @param vertx the Vert.x instance
   * @param realmType the Shiro realm type
   * @param config the config
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.auth.shiro.ShiroAuth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.shiro.ShiroAuthRealmType realmType, JsonObject config) { 
    io.vertx.rxjava.ext.auth.shiro.ShiroAuth ret = io.vertx.rxjava.ext.auth.shiro.ShiroAuth.newInstance((io.vertx.ext.auth.shiro.ShiroAuth)io.vertx.ext.auth.shiro.ShiroAuth.create(vertx.getDelegate(), realmType, config));
    return ret;
  }

  /**
   * Create a Shiro auth provider
   * @param vertx the Vert.x instance
   * @param options the Shiro configuration options
   * @return the auth provider
   */
  public static io.vertx.rxjava.ext.auth.shiro.ShiroAuth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.shiro.ShiroAuthOptions options) { 
    io.vertx.rxjava.ext.auth.shiro.ShiroAuth ret = io.vertx.rxjava.ext.auth.shiro.ShiroAuth.newInstance((io.vertx.ext.auth.shiro.ShiroAuth)io.vertx.ext.auth.shiro.ShiroAuth.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set the role prefix to distinguish from permissions when checking for isPermitted requests.
   * @param rolePrefix a Prefix e.g.: "role:"
   * @return a reference to this for fluency
   */
  public io.vertx.rxjava.ext.auth.shiro.ShiroAuth setRolePrefix(String rolePrefix) { 
    io.vertx.rxjava.ext.auth.shiro.ShiroAuth ret = io.vertx.rxjava.ext.auth.shiro.ShiroAuth.newInstance((io.vertx.ext.auth.shiro.ShiroAuth)delegate.setRolePrefix(rolePrefix));
    return ret;
  }

  /**
   * The default role prefix
   */
  public static final String DEFAULT_ROLE_PREFIX = io.vertx.ext.auth.shiro.ShiroAuth.DEFAULT_ROLE_PREFIX;
  public static ShiroAuth newInstance(io.vertx.ext.auth.shiro.ShiroAuth arg) {
    return arg != null ? new ShiroAuth(arg) : null;
  }

}
