/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.unit;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This object provides callback-ability for the end of a test suite, the completion <i>succeeds</i>
 * when all tests pass otherwise it fails.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.TestCompletion original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.TestCompletion.class)
public class TestCompletion extends io.vertx.rxjava.ext.unit.Completion<Void> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestCompletion that = (TestCompletion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestCompletion> __TYPE_ARG = new TypeArg<>(    obj -> new TestCompletion((io.vertx.ext.unit.TestCompletion) obj),
    TestCompletion::getDelegate
  );

  private final io.vertx.ext.unit.TestCompletion delegate;
  
  public TestCompletion(io.vertx.ext.unit.TestCompletion delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TestCompletion(Object delegate) {
    super((io.vertx.ext.unit.TestCompletion)delegate);
    this.delegate = (io.vertx.ext.unit.TestCompletion)delegate;
  }

  public io.vertx.ext.unit.TestCompletion getDelegate() {
    return delegate;
  }

  /**
   * Completes the future upon completion, otherwise fails it.
   * @param future the future to resolve
   */
  public void resolve(io.vertx.rxjava.core.Promise<Void> future) { 
    delegate.resolve(future.getDelegate());
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @param completionHandler the completion handler
   */
  public void handler(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.handler(completionHandler);
  }

    /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   * @deprecated use {@link #rxHandler} instead
   */
  @Deprecated()
  public Observable<Void> handlerObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    handler(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   */
  public Single<Void> rxHandler() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      handler(fut);
    }));
  }

  public static TestCompletion newInstance(io.vertx.ext.unit.TestCompletion arg) {
    return arg != null ? new TestCompletion(arg) : null;
  }

}
