/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.unit.collect;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The event bus collector listen to events on the Vert.x event bus and translate them
 * into reports.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.collect.EventBusCollector original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.collect.EventBusCollector.class)
public class EventBusCollector {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBusCollector that = (EventBusCollector) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<EventBusCollector> __TYPE_ARG = new TypeArg<>(    obj -> new EventBusCollector((io.vertx.ext.unit.collect.EventBusCollector) obj),
    EventBusCollector::getDelegate
  );

  private final io.vertx.ext.unit.collect.EventBusCollector delegate;
  
  public EventBusCollector(io.vertx.ext.unit.collect.EventBusCollector delegate) {
    this.delegate = delegate;
  }

  public EventBusCollector(Object delegate) {
    this.delegate = (io.vertx.ext.unit.collect.EventBusCollector)delegate;
  }

  public io.vertx.ext.unit.collect.EventBusCollector getDelegate() {
    return delegate;
  }

  /**
   * Create a message handler reporting with the specified options. The returned
   * message handler can be registered to an event bus.
   * @param vertx 
   * @param options the reporting options
   * @return the message handler
   */
  public static io.vertx.rxjava.ext.unit.collect.EventBusCollector create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.unit.report.ReportingOptions options) { 
    io.vertx.rxjava.ext.unit.collect.EventBusCollector ret = io.vertx.rxjava.ext.unit.collect.EventBusCollector.newInstance((io.vertx.ext.unit.collect.EventBusCollector)io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), options));
    return ret;
  }

  public static io.vertx.rxjava.ext.unit.collect.EventBusCollector create(io.vertx.rxjava.core.Vertx vertx, Handler<io.vertx.rxjava.ext.unit.report.TestSuiteReport> reporter) { 
    io.vertx.rxjava.ext.unit.collect.EventBusCollector ret = io.vertx.rxjava.ext.unit.collect.EventBusCollector.newInstance((io.vertx.ext.unit.collect.EventBusCollector)io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), new Handler<io.vertx.ext.unit.report.TestSuiteReport>() {
      public void handle(io.vertx.ext.unit.report.TestSuiteReport event) {
        reporter.handle(io.vertx.rxjava.ext.unit.report.TestSuiteReport.newInstance((io.vertx.ext.unit.report.TestSuiteReport)event));
      }
    }));
    return ret;
  }

  /**
   * Register the collector as a consumer of the event bus with the specified address.
   * @param address the registration address
   * @return the subscribed message consumer
   */
  public io.vertx.rxjava.core.eventbus.MessageConsumer register(String address) { 
    io.vertx.rxjava.core.eventbus.MessageConsumer ret = io.vertx.rxjava.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.register(address));
    return ret;
  }

  /**
   * Json <code>type</code> field value that signals a test suite begins, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_BEGIN = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_BEGIN;
  /**
   * Json <code>type</code> field value that signals a test suite ends, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_END = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_END;
  /**
   * Json <code>type</code> field value that reports a test suite error, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_ERROR = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_ERROR;
  /**
   * Json <code>type</code> field value that signals a test case begins, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_CASE_BEGIN = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_CASE_BEGIN;
  /**
   * Json <code>type</code> field value that signals a test case ends, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_CASE_END = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_CASE_END;
  public static EventBusCollector newInstance(io.vertx.ext.unit.collect.EventBusCollector arg) {
    return arg != null ? new EventBusCollector(arg) : null;
  }

}
