/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.api.contract;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Main interface for Design Driven Router factory
 * Author: Francesco Guardiani @slinkydeveloper
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.contract.RouterFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.contract.RouterFactory.class)
public interface RouterFactory<Specification> {

  io.vertx.ext.web.api.contract.RouterFactory getDelegate();

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory addSecurityHandler(String securitySchemaName, Handler<io.vertx.rxjava.ext.web.RoutingContext> handler);

  /**
   * Set options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param options 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions options);

  /**
   * Get options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @return 
   */
  public io.vertx.ext.web.api.contract.RouterFactoryOptions getOptions();

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   * <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
   * @return 
   */
  public io.vertx.rxjava.ext.web.Router getRouter();

  /**
   * @return 
   */
  @Deprecated()
  public Handler<io.vertx.rxjava.ext.web.RoutingContext> getValidationFailureHandler();

  /**
   * Set default validation failure handler. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param validationFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setValidationFailureHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> validationFailureHandler);

  /**
   * Set not implemented failure handler. It's called when you don't define an handler for a
   * specific operation. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param notImplementedFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setNotImplementedFailureHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> notImplementedFailureHandler);

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files
   * @param bodyHandler 
   * @return self
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setBodyHandler(io.vertx.rxjava.ext.web.handler.BodyHandler bodyHandler);

  /**
   * Add global handler to be applied prior to {@link io.vertx.rxjava.ext.web.Router} being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use {@link io.vertx.rxjava.ext.web.api.contract.RouterFactory#setBodyHandler}
   * @param globalHandler 
   * @return this object
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory addGlobalHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> globalHandler);

  /**
   * When set, this function is called while creating the payload of {@link io.vertx.ext.web.api.OperationRequest}
   * @param extraOperationContextPayloadMapper 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setExtraOperationContextPayloadMapper(Function<io.vertx.rxjava.ext.web.RoutingContext, JsonObject> extraOperationContextPayloadMapper);

  public static <Specification> RouterFactory<Specification> newInstance(io.vertx.ext.web.api.contract.RouterFactory arg) {
    return arg != null ? new RouterFactoryImpl<Specification>(arg) : null;
  }

  public static <Specification> RouterFactory<Specification> newInstance(io.vertx.ext.web.api.contract.RouterFactory arg, TypeArg<Specification> __typeArg_Specification) {
    return arg != null ? new RouterFactoryImpl<Specification>(arg, __typeArg_Specification) : null;
  }

}

class RouterFactoryImpl<Specification> implements RouterFactory<Specification> {
  private final io.vertx.ext.web.api.contract.RouterFactory<Specification> delegate;
  public final TypeArg<Specification> __typeArg_0;
  
  public RouterFactoryImpl(io.vertx.ext.web.api.contract.RouterFactory delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public RouterFactoryImpl(Object delegate, TypeArg<Specification> typeArg_0) {
    this.delegate = (io.vertx.ext.web.api.contract.RouterFactory)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.api.contract.RouterFactory getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.ext.web.RoutingContext> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.ext.web.RoutingContext>(o1 -> io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory addSecurityHandler(String securitySchemaName, Handler<io.vertx.rxjava.ext.web.RoutingContext> handler) { 
    delegate.addSecurityHandler(securitySchemaName, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Set options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param options 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Get options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @return 
   */
  public io.vertx.ext.web.api.contract.RouterFactoryOptions getOptions() { 
    io.vertx.ext.web.api.contract.RouterFactoryOptions ret = delegate.getOptions();
    return ret;
  }

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   * <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
   * @return 
   */
  public io.vertx.rxjava.ext.web.Router getRouter() { 
    io.vertx.rxjava.ext.web.Router ret = io.vertx.rxjava.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.getRouter());
    return ret;
  }

  /**
   * @return 
   */
  @Deprecated()
  public Handler<io.vertx.rxjava.ext.web.RoutingContext> getValidationFailureHandler() { 
    Handler<io.vertx.rxjava.ext.web.RoutingContext> ret = new Handler<io.vertx.rxjava.ext.web.RoutingContext>() {
      public void handle(io.vertx.rxjava.ext.web.RoutingContext event) {
          delegate.getValidationFailureHandler().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Set default validation failure handler. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param validationFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setValidationFailureHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> validationFailureHandler) { 
    delegate.setValidationFailureHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        validationFailureHandler.handle(io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Set not implemented failure handler. It's called when you don't define an handler for a
   * specific operation. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param notImplementedFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setNotImplementedFailureHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> notImplementedFailureHandler) { 
    delegate.setNotImplementedFailureHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        notImplementedFailureHandler.handle(io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files
   * @param bodyHandler 
   * @return self
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setBodyHandler(io.vertx.rxjava.ext.web.handler.BodyHandler bodyHandler) { 
    delegate.setBodyHandler(bodyHandler.getDelegate());
    return this;
  }

  /**
   * Add global handler to be applied prior to {@link io.vertx.rxjava.ext.web.Router} being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use {@link io.vertx.rxjava.ext.web.api.contract.RouterFactory#setBodyHandler}
   * @param globalHandler 
   * @return this object
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory addGlobalHandler(Handler<io.vertx.rxjava.ext.web.RoutingContext> globalHandler) { 
    delegate.addGlobalHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        globalHandler.handle(io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * When set, this function is called while creating the payload of {@link io.vertx.ext.web.api.OperationRequest}
   * @param extraOperationContextPayloadMapper 
   * @return 
   */
  public io.vertx.rxjava.ext.web.api.contract.RouterFactory setExtraOperationContextPayloadMapper(Function<io.vertx.rxjava.ext.web.RoutingContext, JsonObject> extraOperationContextPayloadMapper) { 
    delegate.setExtraOperationContextPayloadMapper(new Function<io.vertx.ext.web.RoutingContext,JsonObject>() {
      public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
        JsonObject ret = extraOperationContextPayloadMapper.apply(io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

}
