/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.codec;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A codec for encoding and decoding HTTP bodies.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.codec.BodyCodec original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.codec.BodyCodec.class)
public class BodyCodec<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyCodec that = (BodyCodec) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<BodyCodec> __TYPE_ARG = new TypeArg<>(    obj -> new BodyCodec((io.vertx.ext.web.codec.BodyCodec) obj),
    BodyCodec::getDelegate
  );

  private final io.vertx.ext.web.codec.BodyCodec<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public BodyCodec(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.codec.BodyCodec)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.codec.BodyCodec getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * @return the UTF-8 string codec
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<String> string() { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<String> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.string(), TypeArg.unknown());
    return ret;
  }

  /**
   * A codec for strings using a specific <code>encoding</code>.
   * @param encoding the encoding
   * @return the codec
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<String> string(String encoding) { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<String> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.string(encoding), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<io.vertx.rxjava.core.buffer.Buffer> buffer() { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.buffer(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<JsonObject> jsonObject() { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<JsonObject> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.jsonObject(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<JsonArray> jsonArray() { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<JsonArray> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.jsonArray(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create and return a codec for Java objects encoded using Jackson mapper.
   * @param type 
   * @return a codec for mapping POJO to Json
   */
  public static <U> io.vertx.rxjava.ext.web.codec.BodyCodec<U> json(java.lang.Class<U> type) { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<U> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.json(io.vertx.lang.rxjava.Helper.unwrap(type)), TypeArg.of(type));
    return ret;
  }

  /**
   * @return a codec that simply discards the response
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<Void> none() { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<Void> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.none(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a codec that buffers the entire body and then apply the <code>decode</code> function and returns the result.
   * @param decode the decode function
   * @return the created codec
   */
  public static <T> io.vertx.rxjava.ext.web.codec.BodyCodec<T> create(Function<io.vertx.rxjava.core.buffer.Buffer, T> decode) { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<T> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.create(new Function<io.vertx.core.buffer.Buffer,T>() {
      public T apply(io.vertx.core.buffer.Buffer arg) {
        T ret = decode.apply(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)arg));
        return ret;
      }
    }), TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that pipes the body to a write stream.
   * <p></p>
   * Same as pipe(stream, true).
   * @param stream the destination tream
   * @return the body codec for a write stream
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<Void> pipe(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<Void> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that pipes the body to a write stream.
   * @param stream the destination stream
   * @param close whether the destination stream should be closed
   * @return the body codec for a write stream
   */
  public static io.vertx.rxjava.ext.web.codec.BodyCodec<Void> pipe(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> stream, boolean close) { 
    io.vertx.rxjava.ext.web.codec.BodyCodec<Void> ret = io.vertx.rxjava.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate(), close), TypeArg.unknown());
    return ret;
  }

  public static <T> BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg) {
    return arg != null ? new BodyCodec<T>(arg) : null;
  }

  public static <T> BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new BodyCodec<T>(arg, __typeArg_T) : null;
  }

}
