/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * This handler should be used if you want to store the User object in the Session so it's available between
 * different requests, without you having re-authenticate each time.
 *
 * It requires that the session handler is already present on previous matching routes.
 *
 * It requires an Auth provider so, if the user is deserialized from a clustered session it knows which Auth provider
 * to associate the session with.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.UserSessionHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.UserSessionHandler.class)
public class UserSessionHandler implements Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserSessionHandler that = (UserSessionHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UserSessionHandler> __TYPE_ARG = new TypeArg<>(    obj -> new UserSessionHandler((io.vertx.ext.web.handler.UserSessionHandler) obj),
    UserSessionHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.UserSessionHandler delegate;
  
  public UserSessionHandler(io.vertx.ext.web.handler.UserSessionHandler delegate) {
    this.delegate = delegate;
  }

  public UserSessionHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.UserSessionHandler)delegate;
  }

  public io.vertx.ext.web.handler.UserSessionHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a new handler
   * @param authProvider The auth provider to use
   * @return the handler
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.web.handler.UserSessionHandler create(io.vertx.rxjava.ext.auth.AuthProvider authProvider) { 
    io.vertx.rxjava.ext.web.handler.UserSessionHandler ret = io.vertx.rxjava.ext.web.handler.UserSessionHandler.newInstance((io.vertx.ext.web.handler.UserSessionHandler)io.vertx.ext.web.handler.UserSessionHandler.create(authProvider.getDelegate()));
    return ret;
  }

  public static UserSessionHandler newInstance(io.vertx.ext.web.handler.UserSessionHandler arg) {
    return arg != null ? new UserSessionHandler(arg) : null;
  }

}
