/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler.graphql;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A message recevied over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ApolloWSMessage.class)
public class ApolloWSMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSMessage that = (ApolloWSMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ApolloWSMessage> __TYPE_ARG = new TypeArg<>(    obj -> new ApolloWSMessage((io.vertx.ext.web.handler.graphql.ApolloWSMessage) obj),
    ApolloWSMessage::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate;
  
  public ApolloWSMessage(io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate) {
    this.delegate = delegate;
  }

  public ApolloWSMessage(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ApolloWSMessage)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSMessage getDelegate() {
    return delegate;
  }

  /**
   * @return the websocket that received the message
   */
  public io.vertx.rxjava.core.http.ServerWebSocket serverWebSocket() { 
    io.vertx.rxjava.core.http.ServerWebSocket ret = io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)delegate.serverWebSocket());
    return ret;
  }

  /**
   * @return the message type
   */
  public io.vertx.ext.web.handler.graphql.ApolloWSMessageType type() { 
    io.vertx.ext.web.handler.graphql.ApolloWSMessageType ret = delegate.type();
    return ret;
  }

  /**
   * @return the message content
   */
  public JsonObject content() { 
    JsonObject ret = delegate.content();
    return ret;
  }

  public static ApolloWSMessage newInstance(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
    return arg != null ? new ApolloWSMessage(arg) : null;
  }

}
