/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler.sockjs;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * You interact with SockJS clients through instances of SockJS socket.
 * <p>
 * The API is very similar to {@link io.vertx.rxjava.core.http.WebSocket}.
 * It implements both  and 
 * so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pump} to pump data with flow control.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.sockjs.SockJSSocket.class)
public class SockJSSocket implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSSocket that = (SockJSSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SockJSSocket> __TYPE_ARG = new TypeArg<>(    obj -> new SockJSSocket((io.vertx.ext.web.handler.sockjs.SockJSSocket) obj),
    SockJSSocket::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSSocket delegate;
  
  public SockJSSocket(io.vertx.ext.web.handler.sockjs.SockJSSocket delegate) {
    this.delegate = delegate;
  }

  public SockJSSocket(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate;
  }

  public io.vertx.ext.web.handler.sockjs.SockJSSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

    /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Single<Void> rxEnd() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(data, handler.toHandler());
    return handler;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_1);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket handler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket write(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  /**
   * Write a {@link java.lang.String} to the socket, encoded in UTF-8.
   * @param data the string to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket write(String data) { 
    delegate.write(data);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket write(String data, Handler<AsyncResult<Void>> handler) { 
    io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.write(data, handler));
    return ret;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

    @Deprecated()
  public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    write(data, handler.toHandler());
    return handler;
  }

  public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>SockJSSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying socket. This
   * allows you to write data to other sockets which are owned by different event loops.
   * @return 
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Call {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end}.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Close it
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close it giving a status code and reason. Only Applicable to RawWebSocket will downgrade to plain close for
   * other transports.
   * @param statusCode 
   * @param reason 
   */
  public void close(int statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Return the remote address for this socket
   * @return 
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress() { 
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    return ret;
  }

  /**
   * Return the local address for this socket
   * @return 
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    return ret;
  }

  /**
   * Return the headers corresponding to the last request for this socket or the websocket handshake
   * Any cookie headers will be removed for security reasons
   * @return 
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Return the URI corresponding to the last request for this socket or the websocket handshake
   * @return 
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the Vert.x-Web session corresponding to this socket
   */
  public io.vertx.rxjava.ext.web.Session webSession() { 
    io.vertx.rxjava.ext.web.Session ret = io.vertx.rxjava.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.webSession());
    return ret;
  }

  /**
   * @return the Vert.x-Web user corresponding to this socket
   */
  public io.vertx.rxjava.ext.auth.User webUser() { 
    io.vertx.rxjava.ext.auth.User ret = io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.webUser());
    return ret;
  }

  public static SockJSSocket newInstance(io.vertx.ext.web.handler.sockjs.SockJSSocket arg) {
    return arg != null ? new SockJSSocket(arg) : null;
  }

}
