/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.sstore;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A session store is used to store sessions for an Vert.x-Web web app
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.SessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionStore that = (SessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore) obj),
    SessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.SessionStore delegate;
  
  public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
    this.delegate = delegate;
  }

  public SessionStore(Object delegate) {
    this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.SessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @return the store or runtime exception
   */
  public static io.vertx.rxjava.ext.web.sstore.SessionStore create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.web.sstore.SessionStore ret = io.vertx.rxjava.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @param options extra options for initialization
   * @return the store or runtime exception
   */
  public static io.vertx.rxjava.ext.web.sstore.SessionStore create(io.vertx.rxjava.core.Vertx vertx, JsonObject options) { 
    io.vertx.rxjava.ext.web.sstore.SessionStore ret = io.vertx.rxjava.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Initialize this store.
   * @param vertx the vertx instance
   * @param options optional Json with extra configuration options
   * @return self
   */
  public io.vertx.rxjava.ext.web.sstore.SessionStore init(io.vertx.rxjava.core.Vertx vertx, JsonObject options) { 
    delegate.init(vertx.getDelegate(), options);
    return this;
  }

  /**
   * The retry timeout value in milli seconds used by the session handler when it retrieves a value from the store.<p/>
   *
   * A non positive value means there is no retry at all.
   * @return the timeout value, in ms
   */
  public long retryTimeout() { 
    long ret = delegate.retryTimeout();
    return ret;
  }

  /**
   * Create a new session using the default min length.
   * @param timeout - the session timeout, in ms
   * @return the session
   */
  public io.vertx.rxjava.ext.web.Session createSession(long timeout) { 
    io.vertx.rxjava.ext.web.Session ret = io.vertx.rxjava.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout));
    return ret;
  }

  /**
   * Create a new session.
   * @param timeout - the session timeout, in ms
   * @param length - the required length for the session id
   * @return the session
   */
  public io.vertx.rxjava.ext.web.Session createSession(long timeout, int length) { 
    io.vertx.rxjava.ext.web.Session ret = io.vertx.rxjava.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout, length));
    return ret;
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @param resultHandler will be called with a result holding the session, or a failure
   */
  public void get(String cookieValue, Handler<AsyncResult<io.vertx.rxjava.ext.web.Session>> resultHandler) { 
    delegate.get(cookieValue, new Handler<AsyncResult<io.vertx.ext.web.Session>>() {
      public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.web.Session.newInstance((io.vertx.ext.web.Session)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @return 
   * @deprecated use {@link #rxGet} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.web.Session> getObservable(String cookieValue) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.web.Session> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    get(cookieValue, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @return 
   */
  public Single<io.vertx.rxjava.ext.web.Session> rxGet(String cookieValue) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      get(cookieValue, fut);
    }));
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @param resultHandler will be called with a success or a failure
   */
  public void delete(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.delete(id, resultHandler);
  }

    /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @return 
   * @deprecated use {@link #rxDelete} instead
   */
  @Deprecated()
  public Observable<Void> deleteObservable(String id) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    delete(id, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @return 
   */
  public Single<Void> rxDelete(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      delete(id, fut);
    }));
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @param resultHandler will be called with a success or a failure
   */
  public void put(io.vertx.rxjava.ext.web.Session session, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.put(session.getDelegate(), resultHandler);
  }

    /**
   * Add a session with the specified ID.
   * @param session the session
   * @return 
   * @deprecated use {@link #rxPut} instead
   */
  @Deprecated()
  public Observable<Void> putObservable(io.vertx.rxjava.ext.web.Session session) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    put(session, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @return 
   */
  public Single<Void> rxPut(io.vertx.rxjava.ext.web.Session session) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      put(session, fut);
    }));
  }

  /**
   * Remove all sessions from the store.
   * @param resultHandler will be called with a success or a failure
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

    /**
   * Remove all sessions from the store.
   * @return 
   * @deprecated use {@link #rxClear} instead
   */
  @Deprecated()
  public Observable<Void> clearObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    clear(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Remove all sessions from the store.
   * @return 
   */
  public Single<Void> rxClear() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      clear(fut);
    }));
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @param resultHandler will be called with the number, or a failure
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

    /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @return 
   * @deprecated use {@link #rxSize} instead
   */
  @Deprecated()
  public Observable<Integer> sizeObservable() { 
    io.vertx.rx.java.ObservableFuture<Integer> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    size(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @return 
   */
  public Single<Integer> rxSize() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      size(fut);
    }));
  }

  /**
   * Close the store
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.SessionStore.DEFAULT_SESSIONID_LENGTH;
  public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
    return arg != null ? new SessionStore(arg) : null;
  }

}
