/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.admin;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaAdminClient> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  public KafkaAdminClient(Object delegate) {
    this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
  }

  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }

  /**
   * Create a new KafkaAdminClient instance
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.rxjava.kafka.admin.KafkaAdminClient create(io.vertx.rxjava.core.Vertx vertx, java.util.Map<String, String> config) { 
    io.vertx.rxjava.kafka.admin.KafkaAdminClient ret = io.vertx.rxjava.kafka.admin.KafkaAdminClient.newInstance((io.vertx.kafka.admin.KafkaAdminClient)io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * @param completionHandler handler called on operation completed with the topics set
   */
  public void listTopics(Handler<AsyncResult<Set<String>>> completionHandler) { 
    delegate.listTopics(completionHandler);
  }

    /**
   * List the topics available in the cluster with the default options.
   * @return 
   */
  public Single<Set<String>> rxListTopics() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listTopics(fut);
    }));
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @param completionHandler handler called on operation completed
   */
  public void createTopics(List<io.vertx.kafka.admin.NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopics(topics, completionHandler);
  }

    /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @return 
   */
  public Single<Void> rxCreateTopics(List<io.vertx.kafka.admin.NewTopic> topics) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createTopics(topics, fut);
    }));
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @param completionHandler handler called on operation completed
   */
  public void deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteTopics(topicNames, completionHandler);
  }

    /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @return 
   */
  public Single<Void> rxDeleteTopics(List<String> topicNames) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deleteTopics(topicNames, fut);
    }));
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @param completionHandler handler called on operation completed with the consumer groups ids
   */
  public void listConsumerGroups(Handler<AsyncResult<List<io.vertx.kafka.admin.ConsumerGroupListing>>> completionHandler) { 
    delegate.listConsumerGroups(completionHandler);
  }

    /**
   * Get the the consumer groups available in the cluster with the default options
   * @return 
   */
  public Single<List<io.vertx.kafka.admin.ConsumerGroupListing>> rxListConsumerGroups() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listConsumerGroups(fut);
    }));
  }

  /**
   * Close the admin client
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the admin client
   * @param completionHandler handler called on operation completed
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

    /**
   * Close the admin client
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Close the admin client
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

    /**
   * Close the admin client
   * @param timeout timeout to wait for closing
   * @return 
   */
  public Single<Void> rxClose(long timeout) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(timeout, fut);
    }));
  }

  public static KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }

}
