/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mqtt;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttClient.class)
public class MqttClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttClient that = (MqttClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg<>(    obj -> new MqttClient((io.vertx.mqtt.MqttClient) obj),
    MqttClient::getDelegate
  );

  private final io.vertx.mqtt.MqttClient delegate;
  
  public MqttClient(io.vertx.mqtt.MqttClient delegate) {
    this.delegate = delegate;
  }

  public MqttClient(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttClient)delegate;
  }

  public io.vertx.mqtt.MqttClient getDelegate() {
    return delegate;
  }

  /**
   * Return an MQTT client instance
   * @param vertx Vert.x instance
   * @param options MQTT client options
   * @return MQTT client instance
   */
  public static io.vertx.rxjava.mqtt.MqttClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.mqtt.MqttClientOptions options) { 
    io.vertx.rxjava.mqtt.MqttClient ret = io.vertx.rxjava.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return an MQTT client instance using the default options
   * @param vertx Vert.x instance
   * @return MQTT client instance
   */
  public static io.vertx.rxjava.mqtt.MqttClient create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.mqtt.MqttClient ret = io.vertx.rxjava.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param connectHandler handler called when the asynchronous connect call ends
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient connect(int port, String host, Handler<AsyncResult<io.vertx.rxjava.mqtt.messages.MqttConnAckMessage>> connectHandler) { 
    delegate.connect(port, host, new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>() {
      public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return current MQTT client instance
   */
  public Single<io.vertx.rxjava.mqtt.messages.MqttConnAckMessage> rxConnect(int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, fut);
    }));
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @param connectHandler handler called when the asynchronous connect call ends
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient connect(int port, String host, String serverName, Handler<AsyncResult<io.vertx.rxjava.mqtt.messages.MqttConnAckMessage>> connectHandler) { 
    delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>() {
      public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return current MQTT client instance
   */
  public Single<io.vertx.rxjava.mqtt.messages.MqttConnAckMessage> rxConnect(int port, String host, String serverName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, serverName, fut);
    }));
  }

  /**
   * Disconnects from the MQTT server
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient disconnect() { 
    delegate.disconnect();
    return this;
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @param disconnectHandler handler called when asynchronous disconnect call ends
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) { 
    delegate.disconnect(disconnectHandler);
    return this;
  }

    /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @return current MQTT client instance
   */
  public Single<Void> rxDisconnect() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      disconnect(fut);
    }));
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient publish(String topic, io.vertx.rxjava.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param publishSentHandler handler called after PUBLISH packet sent with packetid (not when QoS 0)
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient publish(String topic, io.vertx.rxjava.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    return this;
  }

    /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public Single<Integer> rxPublish(String topic, io.vertx.rxjava.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      publish(topic, payload, qosLevel, isDup, isRetain, fut);
    }));
  }

  /**
   * Sets handler which will be called each time publish is completed
   * @param publishCompletionHandler handler called with the packetId
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) { 
    delegate.publishCompletionHandler(publishCompletionHandler);
    return this;
  }

  /**
   * Sets handler which will be called each time server publish something to client
   * @param publishHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient publishHandler(Handler<io.vertx.rxjava.mqtt.messages.MqttPublishMessage> publishHandler) { 
    delegate.publishHandler(new Handler<io.vertx.mqtt.messages.MqttPublishMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
        publishHandler.handle(io.vertx.rxjava.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event));
      }
    });
    return this;
  }

  /**
   * Sets handler which will be called after SUBACK packet receiving
   * @param subscribeCompletionHandler handler to call. List inside is a granted QoS array
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient subscribeCompletionHandler(Handler<io.vertx.rxjava.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) { 
    delegate.subscribeCompletionHandler(new Handler<io.vertx.mqtt.messages.MqttSubAckMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttSubAckMessage event) {
        subscribeCompletionHandler.handle(io.vertx.rxjava.mqtt.messages.MqttSubAckMessage.newInstance((io.vertx.mqtt.messages.MqttSubAckMessage)event));
      }
    });
    return this;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient subscribe(String topic, int qos) { 
    delegate.subscribe(topic, qos);
    return this;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @param subscribeSentHandler handler called after SUBSCRIBE packet sent with packetid
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) { 
    delegate.subscribe(topic, qos, subscribeSentHandler);
    return this;
  }

    /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public Single<Integer> rxSubscribe(String topic, int qos) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscribe(topic, qos, fut);
    }));
  }

  /**
   * Subscribes to the topics with related QoS levels
   * @param topics topics and related QoS levels to subscribe to
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient subscribe(java.util.Map<String, Integer> topics) { 
    delegate.subscribe(topics);
    return this;
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @param subscribeSentHandler handler called after SUBSCRIBE packet sent with packetid
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient subscribe(java.util.Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) { 
    delegate.subscribe(topics, subscribeSentHandler);
    return this;
  }

    /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @return current MQTT client instance
   */
  public Single<Integer> rxSubscribe(java.util.Map<String, Integer> topics) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscribe(topics, fut);
    }));
  }

  /**
   * Sets handler which will be called after UNSUBACK packet receiving
   * @param unsubscribeCompletionHandler handler to call with the packetid
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) { 
    delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic Topic you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient unsubscribe(String topic) { 
    delegate.unsubscribe(topic);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic Topic you want to unsubscribe from
   * @param unsubscribeSentHandler handler called after UNSUBSCRIBE packet sent
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) { 
    delegate.unsubscribe(topic, unsubscribeSentHandler);
    return this;
  }

    /**
   * Unsubscribe from receiving messages on given topic
   * @param topic Topic you want to unsubscribe from
   * @return current MQTT client instance
   */
  public Single<Integer> rxUnsubscribe(String topic) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unsubscribe(topic, fut);
    }));
  }

  /**
   * Sets handler which will be called after PINGRESP packet receiving
   * @param pingResponseHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) { 
    delegate.pingResponseHandler(pingResponseHandler);
    return this;
  }

  /**
   * Set an exception handler for the client, that will be called when an error happens
   * in internal netty structures.
   *
   * <code>io.netty.handler.codec.DecoderException</code> can be one of the cause
   * @param handler the exception handler
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a handler that will be called when the connection with server is closed
   * @param closeHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient closeHandler(Handler<Void> closeHandler) { 
    delegate.closeHandler(closeHandler);
    return this;
  }

  /**
   * This method is needed by the client in order to avoid server closes the
   * connection due to the keep alive timeout if client has no messages to send
   * @return current MQTT client instance
   */
  public io.vertx.rxjava.mqtt.MqttClient ping() { 
    delegate.ping();
    return this;
  }

  /**
   * @return the client identifier
   */
  public String clientId() { 
    String ret = delegate.clientId();
    return ret;
  }

  /**
   * @return if the connection between client and remote server is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
    return arg != null ? new MqttClient(arg) : null;
  }

}
