/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.pgclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to Postgres.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.PgConnection.class)
public class PgConnection extends io.vertx.rxjava.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgConnection that = (PgConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgConnection> __TYPE_ARG = new TypeArg<>(    obj -> new PgConnection((io.vertx.pgclient.PgConnection) obj),
    PgConnection::getDelegate
  );

  private final io.vertx.pgclient.PgConnection delegate;
  
  public PgConnection(io.vertx.pgclient.PgConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgConnection(Object delegate) {
    super((io.vertx.pgclient.PgConnection)delegate);
    this.delegate = (io.vertx.pgclient.PgConnection)delegate;
  }

  public io.vertx.pgclient.PgConnection getDelegate() {
    return delegate;
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options, Handler<AsyncResult<io.vertx.rxjava.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), options, new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return 
   */
  public static Single<io.vertx.rxjava.pgclient.PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, options, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, Handler<AsyncResult<io.vertx.rxjava.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @return 
   */
  public static Single<io.vertx.rxjava.pgclient.PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, String connectionUri, Handler<AsyncResult<io.vertx.rxjava.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static Single<io.vertx.rxjava.pgclient.PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, String connectionUri) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectionUri, fut);
    }));
  }

  /**
   * Set an handler called when the connection receives notification on a channel.
   * <p/>
   * The handler is called with the {@link io.vertx.pgclient.PgNotification} and has access to the channel name
   * and the notification payload.
   * @param handler the handler
   * @return the transaction instance
   */
  public io.vertx.rxjava.pgclient.PgConnection notificationHandler(Handler<io.vertx.pgclient.PgNotification> handler) { 
    delegate.notificationHandler(handler);
    return this;
  }

  /**
   * Send a request cancellation message to tell the server to cancel processing request in this connection.
   * <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
   * @param handler the handler notified if cancelling request is sent
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) { 
    io.vertx.rxjava.pgclient.PgConnection ret = io.vertx.rxjava.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)delegate.cancelRequest(handler));
    return ret;
  }

  /**
   * @return The process ID of the target backend
   */
  public int processId() { 
    int ret = delegate.processId();
    return ret;
  }

  /**
   * @return The secret key for the target backend
   */
  public int secretKey() { 
    int ret = delegate.secretKey();
    return ret;
  }

  /**
   * 
   * @param sql 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.pgclient.PgConnection prepare(String sql, Handler<AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * 
   * @param sql 
   * @return 
   */
  public Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, fut);
    }));
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.pgclient.PgConnection exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.pgclient.PgConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public static PgConnection newInstance(io.vertx.pgclient.PgConnection arg) {
    return arg != null ? new PgConnection(arg) : null;
  }

}
