/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.rabbitmq;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Like {@link com.rabbitmq.client.Envelope}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.Envelope original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.Envelope.class)
public class Envelope {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Envelope that = (Envelope) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Envelope> __TYPE_ARG = new TypeArg<>(    obj -> new Envelope((io.vertx.rabbitmq.Envelope) obj),
    Envelope::getDelegate
  );

  private final io.vertx.rabbitmq.Envelope delegate;
  
  public Envelope(io.vertx.rabbitmq.Envelope delegate) {
    this.delegate = delegate;
  }

  public Envelope(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.Envelope)delegate;
  }

  public io.vertx.rabbitmq.Envelope getDelegate() {
    return delegate;
  }

  /**
   * Get the delivery tag included in this parameter envelope
   * @return the delivery tag
   */
  public long deliveryTag() { 
    if (cached_0 != null) {
      return cached_0;
    }
    long ret = delegate.deliveryTag();
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the redelivery flag included in this parameter envelope. This is a
   * hint as to whether this message may have been delivered before (but not
   * acknowledged). If the flag is not set, the message definitely has not
   * been delivered before. If it is set, it may have been delivered before.
   * @return the redelivery flag
   */
  public boolean isRedelivery() { 
    if (cached_1 != null) {
      return cached_1;
    }
    boolean ret = delegate.isRedelivery();
    cached_1 = ret;
    return ret;
  }

  /**
   * Get the name of the exchange included in this parameter envelope
   * @return the exchange
   */
  public String exchange() { 
    if (cached_2 != null) {
      return cached_2;
    }
    String ret = delegate.exchange();
    cached_2 = ret;
    return ret;
  }

  /**
   * Get the routing key included in this parameter envelope
   * @return the routing key
   */
  public String routingKey() { 
    if (cached_3 != null) {
      return cached_3;
    }
    String ret = delegate.routingKey();
    cached_3 = ret;
    return ret;
  }

  private java.lang.Long cached_0;
  private java.lang.Boolean cached_1;
  private String cached_2;
  private String cached_3;
  public static Envelope newInstance(io.vertx.rabbitmq.Envelope arg) {
    return arg != null ? new Envelope(arg) : null;
  }

}
