/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.redis.client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI append(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.append(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxAppend} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> appendObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    append(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxAppend(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      append(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI asking(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.asking(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   * @deprecated use {@link #rxAsking} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> askingObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    asking(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxAsking() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      asking(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI auth(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.auth(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxAuth} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> authObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    auth(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxAuth(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      auth(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgrewriteaof(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bgrewriteaof(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   * @deprecated use {@link #rxBgrewriteaof} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bgrewriteaofObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bgrewriteaof(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBgrewriteaof() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bgrewriteaof(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgsave(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bgsave(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBgsave} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bgsaveObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bgsave(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBgsave(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bgsave(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitcount(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBitcount} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bitcountObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bitcount(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBitcount(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bitcount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitfield(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBitfield} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bitfieldObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bitfield(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBitfield(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bitfield(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitop(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBitop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bitopObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bitop(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBitop(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bitop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitpos(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBitpos} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bitposObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bitpos(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBitpos(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bitpos(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blpop(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.blpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBlpop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> blpopObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    blpop(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBlpop(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      blpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpop(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.brpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBrpop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> brpopObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    brpop(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBrpop(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      brpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpoplpush(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.brpoplpush(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxBrpoplpush} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> brpoplpushObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    brpoplpush(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBrpoplpush(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      brpoplpush(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmax(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bzpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBzpopmax} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bzpopmaxObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bzpopmax(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBzpopmax(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bzpopmax(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmin(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bzpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxBzpopmin} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> bzpopminObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    bzpopmin(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxBzpopmin(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      bzpopmin(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI client(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.client(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxClient} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> clientObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    client(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxClient(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      client(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cluster(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cluster(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxCluster} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> clusterObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    cluster(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxCluster(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      cluster(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI command(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.command(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @return fluent self
   * @deprecated use {@link #rxCommand} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> commandObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    command(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxCommand() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      command(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI config(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.config(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxConfig} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> configObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    config(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxConfig(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      config(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dbsize(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.dbsize(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   * @deprecated use {@link #rxDbsize} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> dbsizeObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    dbsize(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDbsize() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      dbsize(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI debug(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.debug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxDebug} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> debugObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    debug(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDebug(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      debug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decr(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.decr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxDecr} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> decrObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    decr(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDecr(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      decr(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decrby(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.decrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxDecrby} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> decrbyObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    decrby(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDecrby(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      decrby(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI del(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.del(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxDel} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> delObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    del(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDel(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      del(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI discard(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.discard(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   * @deprecated use {@link #rxDiscard} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> discardObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    discard(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDiscard() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      discard(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dump(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.dump(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxDump} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> dumpObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    dump(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxDump(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      dump(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI echo(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.echo(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxEcho} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> echoObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    echo(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxEcho(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      echo(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI eval(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.eval(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxEval} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> evalObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    eval(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxEval(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      eval(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalsha(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.evalsha(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxEvalsha} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> evalshaObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    evalsha(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxEvalsha(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      evalsha(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exec(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.exec(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   * @deprecated use {@link #rxExec} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> execObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    exec(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxExec() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exec(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exists(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.exists(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxExists} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> existsObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    exists(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxExists(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expire(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.expire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxExpire} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> expireObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    expire(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxExpire(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      expire(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expireat(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.expireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxExpireat} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> expireatObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    expireat(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxExpireat(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      expireat(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushall(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.flushall(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxFlushall} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> flushallObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    flushall(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxFlushall(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      flushall(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushdb(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.flushdb(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxFlushdb} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> flushdbObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    flushdb(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxFlushdb(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      flushdb(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geoadd(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geoadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeoadd} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> geoaddObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    geoadd(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeoadd(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      geoadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geodist(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geodist(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeodist} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> geodistObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    geodist(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeodist(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      geodist(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geohash(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geohash(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeohash} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> geohashObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    geohash(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeohash(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      geohash(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geopos(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geopos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeopos} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> geoposObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    geopos(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeopos(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      geopos(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadius(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadius(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeoradius} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> georadiusObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    georadius(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeoradius(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      georadius(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusRo(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeoradiusRo} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> georadiusRoObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    georadiusRo(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusRo(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      georadiusRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymember(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusbymember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeoradiusbymember} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> georadiusbymemberObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    georadiusbymember(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusbymember(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      georadiusbymember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymemberRo(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusbymemberRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxGeoradiusbymemberRo} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> georadiusbymemberRoObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    georadiusbymemberRo(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusbymemberRo(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      georadiusbymemberRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI get(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.get(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxGet} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> getObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    get(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGet(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      get(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getbit(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getbit(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxGetbit} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> getbitObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    getbit(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGetbit(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getbit(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxGetrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> getrangeObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    getrange(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGetrange(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getset(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getset(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxGetset} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> getsetObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    getset(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxGetset(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getset(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hdel(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHdel} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hdelObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hdel(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHdel(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hexists(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hexists(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxHexists} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hexistsObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hexists(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHexists(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hexists(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hget(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hget(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxHget} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hgetObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hget(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHget(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hget(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hgetall(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hgetall(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxHgetall} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hgetallObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hgetall(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHgetall(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hgetall(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxHincrby} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hincrbyObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hincrby(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHincrby(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hincrby(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrbyfloat(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hincrbyfloat(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxHincrbyfloat} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hincrbyfloatObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hincrbyfloat(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHincrbyfloat(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hincrbyfloat(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hkeys(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hkeys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxHkeys} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hkeysObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hkeys(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHkeys(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hkeys(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hlen(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxHlen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hlenObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hlen(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHlen(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmget(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hmget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHmget} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hmgetObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hmget(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHmget(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hmget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmset(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hmset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHmset} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hmsetObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hmset(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHmset(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hmset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI host(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.host(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHost} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hostObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    host(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHost(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      host(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hscan(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHscan} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hscanObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hscan(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHscan(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hset(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxHset} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hsetObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hset(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHset(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hsetnx(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hsetnx(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxHsetnx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hsetnxObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hsetnx(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHsetnx(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hsetnx(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hstrlen(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hstrlen(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxHstrlen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hstrlenObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hstrlen(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHstrlen(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hstrlen(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hvals(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hvals(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxHvals} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> hvalsObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    hvals(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxHvals(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      hvals(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incr(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxIncr} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> incrObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    incr(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxIncr(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      incr(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrby(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxIncrby} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> incrbyObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    incrby(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxIncrby(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      incrby(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrbyfloat(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incrbyfloat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxIncrbyfloat} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> incrbyfloatObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    incrbyfloat(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxIncrbyfloat(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      incrbyfloat(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI info(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.info(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxInfo} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> infoObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    info(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxInfo(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      info(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI keys(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.keys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxKeys} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> keysObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    keys(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxKeys(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      keys(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lastsave(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lastsave(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   * @deprecated use {@link #rxLastsave} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lastsaveObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lastsave(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLastsave() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lastsave(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI latency(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.latency(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxLatency} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> latencyObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    latency(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLatency(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      latency(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lindex(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lindex(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxLindex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lindexObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lindex(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLindex(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lindex(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI linsert(String arg0, String arg1, String arg2, String arg3, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.linsert(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   * @deprecated use {@link #rxLinsert} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> linsertObservable(String arg0, String arg1, String arg2, String arg3) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    linsert(arg0, arg1, arg2, arg3, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLinsert(String arg0, String arg1, String arg2, String arg3) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      linsert(arg0, arg1, arg2, arg3, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI llen(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.llen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxLlen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> llenObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    llen(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLlen(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      llen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lolwut(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lolwut(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxLolwut} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lolwutObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lolwut(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLolwut(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lolwut(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpop(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxLpop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lpopObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lpop(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLpop(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lpop(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpush(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxLpush} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lpushObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lpush(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLpush(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lpush(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpushx(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxLpushx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lpushxObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lpushx(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLpushx(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lpushx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxLrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lrangeObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lrange(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLrange(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrem(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lrem(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxLrem} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lremObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lrem(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLrem(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lrem(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lset(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lset(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxLset} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> lsetObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    lset(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLset(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      lset(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ltrim(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ltrim(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxLtrim} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> ltrimObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    ltrim(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxLtrim(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ltrim(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI memory(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.memory(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxMemory} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> memoryObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    memory(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMemory(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      memory(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mget(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.mget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxMget} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> mgetObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    mget(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMget(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      mget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI migrate(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.migrate(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxMigrate} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> migrateObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    migrate(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMigrate(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      migrate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI module(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.module(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxModule} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> moduleObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    module(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxModule(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      module(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI monitor(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.monitor(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   * @deprecated use {@link #rxMonitor} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> monitorObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    monitor(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMonitor() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      monitor(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI move(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.move(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxMove} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> moveObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    move(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMove(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      move(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mset(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.mset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxMset} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> msetObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    mset(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMset(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      mset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI msetnx(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.msetnx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxMsetnx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> msetnxObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    msetnx(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMsetnx(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      msetnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI multi(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.multi(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   * @deprecated use {@link #rxMulti} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> multiObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    multi(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxMulti() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      multi(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI object(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.object(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxObject} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> objectObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    object(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxObject(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      object(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI persist(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.persist(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxPersist} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> persistObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    persist(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPersist(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      persist(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpire(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pexpire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxPexpire} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pexpireObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pexpire(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPexpire(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pexpire(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpireat(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pexpireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxPexpireat} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pexpireatObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pexpireat(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPexpireat(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pexpireat(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfadd(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPfadd} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pfaddObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pfadd(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPfadd(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pfadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfcount(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPfcount} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pfcountObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pfcount(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPfcount(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pfcount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfdebug(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfdebug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPfdebug} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pfdebugObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pfdebug(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPfdebug(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pfdebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfmerge(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfmerge(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPfmerge} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pfmergeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pfmerge(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPfmerge(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pfmerge(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfselftest(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfselftest(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   * @deprecated use {@link #rxPfselftest} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pfselftestObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pfselftest(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPfselftest() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pfselftest(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ping(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ping(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPing} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pingObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    ping(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPing(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ping(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI post(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.post(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPost} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> postObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    post(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPost(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      post(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psetex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psetex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxPsetex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> psetexObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    psetex(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPsetex(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      psetex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psubscribe(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPsubscribe} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> psubscribeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    psubscribe(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPsubscribe(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      psubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psync(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psync(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxPsync} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> psyncObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    psync(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPsync(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      psync(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pttl(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxPttl} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pttlObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pttl(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPttl(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pttl(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI publish(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.publish(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxPublish} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> publishObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    publish(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPublish(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      publish(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pubsub(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pubsub(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPubsub} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> pubsubObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pubsub(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPubsub(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pubsub(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI punsubscribe(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.punsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxPunsubscribe} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> punsubscribeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    punsubscribe(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxPunsubscribe(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      punsubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI randomkey(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.randomkey(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   * @deprecated use {@link #rxRandomkey} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> randomkeyObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    randomkey(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRandomkey() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      randomkey(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readonly(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.readonly(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   * @deprecated use {@link #rxReadonly} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> readonlyObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    readonly(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxReadonly() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      readonly(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readwrite(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.readwrite(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   * @deprecated use {@link #rxReadwrite} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> readwriteObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    readwrite(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxReadwrite() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      readwrite(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rename(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rename(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxRename} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> renameObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    rename(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRename(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      rename(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI renamenx(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.renamenx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxRenamenx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> renamenxObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    renamenx(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRenamenx(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      renamenx(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replconf(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.replconf(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxReplconf} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> replconfObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    replconf(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxReplconf(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      replconf(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replicaof(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.replicaof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxReplicaof} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> replicaofObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    replicaof(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxReplicaof(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      replicaof(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.restore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxRestore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> restoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    restore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRestore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      restore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restoreAsking(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.restoreAsking(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxRestoreAsking} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> restoreAskingObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    restoreAsking(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRestoreAsking(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      restoreAsking(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI role(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.role(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   * @deprecated use {@link #rxRole} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> roleObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    role(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRole() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      role(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpop(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxRpop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> rpopObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    rpop(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRpop(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      rpop(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpoplpush(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpoplpush(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxRpoplpush} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> rpoplpushObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    rpoplpush(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRpoplpush(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      rpoplpush(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpush(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxRpush} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> rpushObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    rpush(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRpush(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      rpush(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpushx(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxRpushx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> rpushxObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    rpushx(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxRpushx(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      rpushx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sadd(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSadd} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> saddObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sadd(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSadd(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI save(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.save(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   * @deprecated use {@link #rxSave} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> saveObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    save(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSave() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      save(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scan(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.scan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxScan} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> scanObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    scan(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxScan(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      scan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scard(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.scard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxScard} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> scardObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    scard(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxScard(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      scard(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI script(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.script(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxScript} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> scriptObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    script(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxScript(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      script(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiff(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSdiff} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sdiffObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sdiff(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSdiff(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sdiff(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiffstore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSdiffstore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sdiffstoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sdiffstore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSdiffstore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sdiffstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI select(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.select(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxSelect} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> selectObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    select(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSelect(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      select(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI set(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.set(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSet} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> setObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    set(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSet(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      set(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setbit(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setbit(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxSetbit} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> setbitObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setbit(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSetbit(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setbit(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxSetex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> setexObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setex(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSetex(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setnx(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setnx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxSetnx} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> setnxObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setnx(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSetnx(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setnx(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxSetrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> setrangeObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setrange(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSetrange(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI shutdown(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.shutdown(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxShutdown} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> shutdownObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    shutdown(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxShutdown(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      shutdown(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinter(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSinter} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sinterObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sinter(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSinter(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sinter(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinterstore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSinterstore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sinterstoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sinterstore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSinterstore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sinterstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sismember(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sismember(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxSismember} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sismemberObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sismember(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSismember(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sismember(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slaveof(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.slaveof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxSlaveof} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> slaveofObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    slaveof(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSlaveof(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      slaveof(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slowlog(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.slowlog(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSlowlog} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> slowlogObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    slowlog(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSlowlog(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      slowlog(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smembers(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.smembers(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxSmembers} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> smembersObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    smembers(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSmembers(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      smembers(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smove(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.smove(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxSmove} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> smoveObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    smove(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSmove(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      smove(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sort(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sort(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSort} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sortObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sort(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSort(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sort(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI spop(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.spop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSpop} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> spopObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    spop(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSpop(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      spop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srandmember(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.srandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSrandmember} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> srandmemberObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    srandmember(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSrandmember(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      srandmember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srem(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.srem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSrem} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sremObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    srem(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSrem(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      srem(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sscan(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSscan} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sscanObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sscan(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSscan(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI strlen(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.strlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxStrlen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> strlenObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    strlen(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxStrlen(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      strlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI subscribe(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.subscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSubscribe} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> subscribeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    subscribe(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSubscribe(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI substr(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.substr(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxSubstr} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> substrObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    substr(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSubstr(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      substr(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunion(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSunion} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sunionObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sunion(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSunion(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sunion(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunionstore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxSunionstore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> sunionstoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sunionstore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSunionstore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sunionstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI swapdb(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.swapdb(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxSwapdb} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> swapdbObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    swapdb(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSwapdb(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      swapdb(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sync(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sync(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   * @deprecated use {@link #rxSync} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> syncObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sync(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxSync() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sync(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI time(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.time(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   * @deprecated use {@link #rxTime} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> timeObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    time(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxTime() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      time(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI touch(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.touch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxTouch} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> touchObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    touch(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxTouch(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      touch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ttl(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxTtl} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> ttlObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    ttl(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxTtl(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ttl(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI type(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.type(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxType} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> typeObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    type(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxType(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      type(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unlink(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unlink(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxUnlink} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> unlinkObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    unlink(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxUnlink(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unlink(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unsubscribe(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxUnsubscribe} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> unsubscribeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    unsubscribe(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxUnsubscribe(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unsubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unwatch(Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unwatch(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   * @deprecated use {@link #rxUnwatch} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> unwatchObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    unwatch(handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxUnwatch() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unwatch(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI wait(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.wait(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxWait} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> waitObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    wait(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxWait(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      wait(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI watch(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.watch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxWatch} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> watchObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    watch(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxWatch(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      watch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xack(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xack(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXack} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xackObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xack(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXack(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xack(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xadd(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXadd} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xaddObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xadd(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXadd(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xclaim(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXclaim} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xclaimObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xclaim(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXclaim(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xclaim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xdel(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXdel} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xdelObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xdel(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXdel(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xgroup(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXgroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xgroupObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xgroup(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXgroup(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xgroup(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xinfo(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xinfo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXinfo} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xinfoObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xinfo(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXinfo(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xinfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xlen(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxXlen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xlenObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xlen(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXlen(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xpending(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xpending(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXpending} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xpendingObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xpending(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXpending(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xpending(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrange(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xrangeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xrange(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXrange(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xread(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xread(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXread} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xreadObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xread(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXread(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xread(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xreadgroup(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xreadgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXreadgroup} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xreadgroupObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xreadgroup(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXreadgroup(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xreadgroup(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrevrange(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXrevrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xrevrangeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xrevrange(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXrevrange(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xrevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xsetid(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xsetid(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxXsetid} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xsetidObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xsetid(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXsetid(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xsetid(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xtrim(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xtrim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxXtrim} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> xtrimObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    xtrim(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxXtrim(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      xtrim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zadd(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZadd} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zaddObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zadd(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZadd(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcard(String arg0, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zcard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   * @deprecated use {@link #rxZcard} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zcardObservable(String arg0) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zcard(arg0, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZcard(String arg0) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zcard(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcount(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZcount} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zcountObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zcount(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZcount(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zcount(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZincrby} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zincrbyObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zincrby(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZincrby(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zincrby(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zinterstore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZinterstore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zinterstoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zinterstore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZinterstore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zinterstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zlexcount(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zlexcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZlexcount} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zlexcountObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zlexcount(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZlexcount(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zlexcount(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmax(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZpopmax} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zpopmaxObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zpopmax(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZpopmax(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zpopmax(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmin(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZpopmin} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zpopminObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zpopmin(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZpopmin(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zpopmin(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrange(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrangeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrange(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrange(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebylex(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrangebylex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrangebylexObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrangebylex(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrangebylex(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrangebylex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebyscore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrangebyscore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrangebyscoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrangebyscore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrangebyscore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrangebyscore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrank(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxZrank} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrankObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrank(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrank(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrank(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrem(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrem} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zremObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrem(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrem(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrem(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebylex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebylex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZremrangebylex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zremrangebylexObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zremrangebylex(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZremrangebylex(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zremrangebylex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyrank(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebyrank(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZremrangebyrank} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zremrangebyrankObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zremrangebyrank(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZremrangebyrank(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zremrangebyrank(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyscore(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebyscore(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   * @deprecated use {@link #rxZremrangebyscore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zremrangebyscoreObservable(String arg0, String arg1, String arg2) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zremrangebyscore(arg0, arg1, arg2, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZremrangebyscore(String arg0, String arg1, String arg2) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zremrangebyscore(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrange(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrevrange} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrevrangeObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrevrange(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrevrange(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebylex(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrevrangebylex} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrevrangebylexObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrevrangebylex(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrevrangebylex(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrevrangebylex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebyscore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZrevrangebyscore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrevrangebyscoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrevrangebyscore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrevrangebyscore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrevrangebyscore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrank(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxZrevrank} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zrevrankObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zrevrank(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZrevrank(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zrevrank(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscan(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZscan} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zscanObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zscan(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZscan(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscore(String arg0, String arg1, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zscore(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   * @deprecated use {@link #rxZscore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zscoreObservable(String arg0, String arg1) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zscore(arg0, arg1, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZscore(String arg0, String arg1) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zscore(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zunionstore(List<String> args, Handler<AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   * @deprecated use {@link #rxZunionstore} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.redis.client.Response> zunionstoreObservable(List<String> args) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.redis.client.Response> handler = io.vertx.rx.java.RxHelper.observableFuture();
    zunionstore(args, handler.toHandler());
    return handler;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public Single<io.vertx.rxjava.redis.client.Response> rxZunionstore(List<String> args) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      zunionstore(args, fut);
    }));
  }

  public static io.vertx.rxjava.redis.client.RedisAPI api(io.vertx.rxjava.redis.client.Redis client) { 
    io.vertx.rxjava.redis.client.RedisAPI ret = io.vertx.rxjava.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava.redis.client.RedisAPI api(io.vertx.rxjava.redis.client.RedisConnection connection) { 
    io.vertx.rxjava.redis.client.RedisAPI ret = io.vertx.rxjava.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
