/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents single row of the result set.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Row original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Row.class)
public class Row extends io.vertx.rxjava.sqlclient.Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Row that = (Row) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Row> __TYPE_ARG = new TypeArg<>(    obj -> new Row((io.vertx.sqlclient.Row) obj),
    Row::getDelegate
  );

  private final io.vertx.sqlclient.Row delegate;
  
  public Row(io.vertx.sqlclient.Row delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Row(Object delegate) {
    super((io.vertx.sqlclient.Row)delegate);
    this.delegate = (io.vertx.sqlclient.Row)delegate;
  }

  public io.vertx.sqlclient.Row getDelegate() {
    return delegate;
  }

  /**
   * Get a column name at <code>pos</code>.
   * @param pos the column position
   * @return the column name or <code>null</code>
   */
  public String getColumnName(int pos) { 
    String ret = delegate.getColumnName(pos);
    return ret;
  }

  /**
   * Get a column position for the given column <code>name</code>.
   * @param name the column name
   * @return the column name or <code>-1</code> if not found
   */
  public int getColumnIndex(String name) { 
    int ret = delegate.getColumnIndex(name);
    return ret;
  }

  /**
   * Get an object value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Object getValue(String name) { 
    java.lang.Object ret = (Object) delegate.getValue(name);
    return ret;
  }

  /**
   * Get a boolean value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Boolean getBoolean(String name) { 
    Boolean ret = delegate.getBoolean(name);
    return ret;
  }

  /**
   * Get a short value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Short getShort(String name) { 
    Short ret = delegate.getShort(name);
    return ret;
  }

  /**
   * Get an integer value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Integer getInteger(String name) { 
    Integer ret = delegate.getInteger(name);
    return ret;
  }

  /**
   * Get a long value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Long getLong(String name) { 
    Long ret = delegate.getLong(name);
    return ret;
  }

  /**
   * Get a float value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Float getFloat(String name) { 
    Float ret = delegate.getFloat(name);
    return ret;
  }

  /**
   * Get a double value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Double getDouble(String name) { 
    Double ret = delegate.getDouble(name);
    return ret;
  }

  /**
   * Get a string value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public String getString(String name) { 
    String ret = delegate.getString(name);
    return ret;
  }

  /**
   * Get a buffer value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public io.vertx.rxjava.core.buffer.Buffer getBuffer(String name) { 
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(name));
    return ret;
  }

  /**
   * Get a temporal value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.temporal.Temporal getTemporal(String name) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalDate getLocalDate(String name) { 
    java.time.LocalDate ret = delegate.getLocalDate(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalTime getLocalTime(String name) { 
    java.time.LocalTime ret = delegate.getLocalTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalDateTime getLocalDateTime(String name) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.OffsetTime getOffsetTime(String name) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.OffsetDateTime getOffsetDateTime(String name) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(name);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.util.UUID getUUID(String name) { 
    java.util.UUID ret = delegate.getUUID(name);
    return ret;
  }

  /**
   * Get  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.math.BigDecimal getBigDecimal(String name) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Boolean[] getBooleanArray(String name) { 
    java.lang.Boolean[] ret = delegate.getBooleanArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Short} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Short[] getShortArray(String name) { 
    java.lang.Short[] ret = delegate.getShortArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Integer[] getIntegerArray(String name) { 
    java.lang.Integer[] ret = delegate.getIntegerArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Long[] getLongArray(String name) { 
    java.lang.Long[] ret = delegate.getLongArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Float} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Float[] getFloatArray(String name) { 
    java.lang.Float[] ret = delegate.getFloatArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Double} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.Double[] getDoubleArray(String name) { 
    java.lang.Double[] ret = delegate.getDoubleArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.String} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.lang.String[] getStringArray(String name) { 
    java.lang.String[] ret = delegate.getStringArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.temporal.Temporal[] getTemporalArray(String name) { 
    java.time.temporal.Temporal[] ret = delegate.getTemporalArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalDate[] getLocalDateArray(String name) { 
    java.time.LocalDate[] ret = delegate.getLocalDateArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalTime[] getLocalTimeArray(String name) { 
    java.time.LocalTime[] ret = delegate.getLocalTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.LocalDateTime[] getLocalDateTimeArray(String name) { 
    java.time.LocalDateTime[] ret = delegate.getLocalDateTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.OffsetTime[] getOffsetTimeArray(String name) { 
    java.time.OffsetTime[] ret = delegate.getOffsetTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.time.OffsetDateTime[] getOffsetDateTimeArray(String name) { 
    java.time.OffsetDateTime[] ret = delegate.getOffsetDateTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.util.UUID[] getUUIDArray(String name) { 
    java.util.UUID[] ret = delegate.getUUIDArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public java.math.BigDecimal[] getBigDecimalArray(String name) { 
    java.math.BigDecimal[] ret = delegate.getBigDecimalArray(name);
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final java.lang.Object JSON_NULL = (Object) io.vertx.sqlclient.Row.JSON_NULL;
  public static Row newInstance(io.vertx.sqlclient.Row arg) {
    return arg != null ? new Row(arg) : null;
  }

}
